/**
 * ProvenanceContainer.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.provenance;

import adams.gui.flow.provenance.ProvenanceNode;

/**
 * Interface for containers that store provenance information.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2791 $
 */
public interface ProvenanceContainer {

  /**
   * Returns whether provenance is available.
   *
   * @return		true if provenance is available
   */
  public boolean hasProvenance();

  /**
   * Sets the provenance to use.
   *
   * @param value	the provenance
   */
  public void setProvenance(ProvenanceNode value);

  /**
   * Returns the current provenance.
   *
   * @return		the provenance, null if none available
   */
  public ProvenanceNode getProvenance();

  /**
   * Adds the provenance information to the internal structure.
   *
   * @param info	the info to add
   */
  public void addProvenance(ProvenanceInformation info);

  /**
   * Sets the provenance information. The "info" provenance information will
   * be the result of the parent nodes in the provenance tree.
   *
   * @param info	the provenance information to add (the new root node)
   * @param parents	the parent provenance information of the new node
   */
  public void mergeProvenance(ProvenanceInformation info, ProvenanceNode[] parents);
}
