/**
 * AbstractDisplayPanel.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.sink;

import adams.core.CleanUpHandler;
import adams.flow.core.Token;
import adams.gui.core.BasePanel;

/**
 * Ancestor for panels that can be created from tokens.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 763 $
 */
public abstract class AbstractDisplayPanel
  extends BasePanel
  implements CleanUpHandler {

  /** for serialization. */
  private static final long serialVersionUID = -5927414957277106664L;

  /** the name of the panel. */
  protected String m_PanelName;

  /**
   * Initializes the panel.
   *
   * @param name	the name of the panel
   */
  public AbstractDisplayPanel(String name) {
    super();

    m_PanelName = name;
  }

  /**
   * Returns the name of the panel.
   *
   * @return		the name
   */
  public String getPanelName() {
    return m_PanelName;
  }

  /**
   * Displays the token.
   *
   * @param token	the token to display
   */
  public abstract void display(Token token);
}