/**
 * AbstractSequencePostProcessor.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.sink.sequenceplotter;

import adams.core.option.AbstractOptionHandler;
import adams.flow.sink.SequencePlotter;
import adams.gui.visualization.sequence.XYSequenceContainerManager;

/**
 * Ancestor for sequence post-processors for the SequencePlotter.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4397 $
 * @see SequencePlotter
 */
public abstract class AbstractSequencePostProcessor
  extends AbstractOptionHandler {

  /** for serialization. */
  private static final long serialVersionUID = 292292424832784658L;

  /**
   * Post-processes the sequences.
   *
   * @param manager	the sequence manager
   * @param plotName	the plot that was modified
   * @return		true if any sequence was modified
   */
  public abstract boolean postProcess(XYSequenceContainerManager manager, String plotName);
}
