/**
 * BooleanExpressionEditorPanel.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.core;

import adams.core.Properties;

/**
 * Text editor pane with syntax highlighting for boolean expressions.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4563 $
 */
public class BooleanExpressionEditorPanel
  extends AbstractTextEditorPanelWithSyntaxHighlighting {

  /** for serialization. */
  private static final long serialVersionUID = -6311158717675828816L;

  /** the props file with the style definitions. */
  public final static String FILENAME = "adams/gui/core/BooleanExpressionEditorPanel.props";

  /**
   * Returns the syntax style definition.
   *
   * @return		the props file with the definitions
   */
  protected Properties getStyleProperties() {
    try {
      return Properties.read(FILENAME);
    }
    catch (Exception e) {
      System.err.println("Failed to load style definitions '" + FILENAME + "': ");
      e.printStackTrace();
      return new Properties();
    }
  }
}
