/*
 * KeyUtils.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.core;

import java.awt.event.KeyEvent;

/**
 * A helper class for key events.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 32 $
 */
public class KeyUtils {
  
  /**
   * Checks whether the key event was a "copy to clipboard" combination
   * (Ctrl+C or Ctrl+Ins).
   * 
   * @param e		the event
   * @return		true if a "copy" event
   */
  public static boolean isCopy(KeyEvent e) {
    boolean	result;
    
    result = false;
    
    if (e.isControlDown() && !e.isAltDown() && !e.isShiftDown() && (e.getKeyCode() == KeyEvent.VK_C))
      result = true;
    else if (e.isControlDown() && !e.isAltDown() && !e.isShiftDown() && (e.getKeyCode() == KeyEvent.VK_INSERT))
      result = true;
    
    return result;
  }
  
  /**
   * Checks whether the key event was a "cut to clipboard" combination
   * (Ctrl+X or Shift+Delete).
   * 
   * @param e		the event
   * @return		true if a "cut" event
   */
  public static boolean isCut(KeyEvent e) {
    boolean	result;
    
    result = false;
    
    if (e.isControlDown() && !e.isAltDown() && !e.isShiftDown() && (e.getKeyCode() == KeyEvent.VK_X))
      result = true;
    else if (!e.isControlDown() && !e.isAltDown() && e.isShiftDown() && (e.getKeyCode() == KeyEvent.VK_DELETE))
      result = true;
    
    return result;
  }
  
  /**
   * Checks whether the key event was a "insert from clipboard" combination
   * (Ctrl+V or Shift+Ins).
   * 
   * @param e		the event
   * @return		true if a "paste" event
   */
  public static boolean isPaste(KeyEvent e) {
    boolean	result;
    
    result = false;
    
    if (e.isControlDown() && !e.isAltDown() && !e.isShiftDown() && (e.getKeyCode() == KeyEvent.VK_V))
      result = true;
    else if (!e.isControlDown() && !e.isAltDown() && e.isShiftDown() && (e.getKeyCode() == KeyEvent.VK_INSERT))
      result = true;
    
    return result;
  }
}
