/**
 * HelpDialog.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BorderFactory;
import javax.swing.JEditorPane;

import adams.gui.core.BaseDialog;
import adams.gui.core.BaseScrollPane;

/**
 * Dialog for displaying help text (HTML or plain text).
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2739 $
 */
public class HelpDialog
  extends BaseDialog {

  /** for serialization. */
  private static final long serialVersionUID = 8716599240055591957L;

  /** for displaying the help text. */
  protected JEditorPane m_TextArea;

  /**
   * Initializes the dialog.
   *
   * @param parent	the parent window
   */
  public HelpDialog(Dialog parent) {
    super(parent);
  }

  /**
   * Initializes the dialog.
   *
   * @param parent	the parent window
   */
  public HelpDialog(Frame parent) {
    super(parent);
  }

  /**
   * Initializes the dialog.
   */
  protected void initGUI() {
    super.initGUI();

    setTitle("Help");

    m_TextArea = new JEditorPane();
    m_TextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    m_TextArea.setEditable(false);
    m_TextArea.setFont(new Font("monospaced", Font.PLAIN, 12));
    m_TextArea.setAutoscrolls(true);

    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
	close();
      }
    });

    getContentPane().setLayout(new BorderLayout());
    getContentPane().add(new BaseScrollPane(m_TextArea), BorderLayout.CENTER);
    pack();
  }

  /**
   * Closes the dialog.
   */
  protected void close() {
    dispose();
  }

  /**
   * Sets the help text.
   *
   * @param value	the help text
   * @param isHtml	whether the text is html or plain text
   */
  public void setHelp(String value, boolean isHtml) {
    if (isHtml)
      m_TextArea.setContentType("text/html");
    else
      m_TextArea.setContentType("text/plain");
    m_TextArea.setText(value);
    m_TextArea.setCaretPosition(0);
 }
}
