/**
 * FilterListener.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.event;

import adams.data.container.DataContainer;

/**
 * Interface for classes that want to listen to events that trigger filtering.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 456 $
 * @param <T> the type of data the filter handles
 */
public interface FilterListener<T extends DataContainer> {

  /**
   * Gets called when the filtering should be executed.
   *
   * @param e		the event
   */
  public void filter(FilterEvent<T> e);
}
