/*
 * AbstractSequenceViewer.java
 * Copyright (C) 2009-2011 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.UserMode;
import adams.gui.tools.AbstractSequenceViewerPanel;

/**
 * Opens the sequence viewer.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4568 $
 */
public abstract class AbstractSequenceViewer
  extends AbstractMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = -1041273949195204507L;

  /**
   * Initializes the menu item with no owner.
   */
  public AbstractSequenceViewer() {
    this(null);
  }

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public AbstractSequenceViewer(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Return the sequence panel.
   *
   * @return		the panel
   */
  protected abstract AbstractSequenceViewerPanel newPanel();

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    createChildFrame(newPanel(), 1000, 800);
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "Sequence viewer";
  }

  /**
   * Returns the file name of the icon.
   *
   * @return		the filename or null if no icon available
   */
  public String getIconName() {
    return "sequence.gif";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return false;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.EXPERT;
  }

  /**
   * Returns the category of the menu item in which it should appear, i.e.,
   * the name of the menu.
   *
   * @return		the category/menu name
   */
  public String getCategory() {
    return CATEGORY_MAINTENANCE;
  }
}