/*
 * AbstractURLMenuItemCodelet.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import adams.gui.core.BrowserHelper;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;

/**
 * Ancestor for menu item definitions that open a URL in a browser.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4568 $
 */
public abstract class AbstractURLMenuItemDefinition
  extends AbstractMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = 4757574306275240997L;

  /**
   * Initializes the menu item with no owner.
   */
  public AbstractURLMenuItemDefinition() {
    this(null);
  }

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public AbstractURLMenuItemDefinition(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * The URL to open in a browser.
   *
   * @return		the URL
   */
  protected abstract String getURL();

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    BrowserHelper.openURL(getOwner(), getURL());
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return false;
  }
}