/*
 * FlowControlCenter.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import adams.core.io.PlaceholderFile;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.UserMode;
import adams.gui.flow.FlowControlCenterPanel;

/**
 * Opens the Flow Control Center.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4568 $
 */
public class FlowControlCenter
  extends AbstractParameterHandlingMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = -7896350435136393906L;

  /**
   * Initializes the menu item with no owner.
   */
  public FlowControlCenter() {
    this(null);
  }

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public FlowControlCenter(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Returns the file name of the icon.
   *
   * @return		the filename or null if no icon available
   */
  public String getIconName() {
    return "flowcc.gif";
  }

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    FlowControlCenterPanel panel = new FlowControlCenterPanel();
    createChildFrame(panel, 800, 600);
    if (m_Parameters.length > 0)
      panel.load(new PlaceholderFile(m_Parameters[0]));
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "Flow control center";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return false;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.BASIC;
  }

  /**
   * Returns the category of the menu item in which it should appear, i.e.,
   * the name of the menu.
   *
   * @return		the category/menu name
   */
  public String getCategory() {
    return CATEGORY_TOOLS;
  }
}