/*
 * ProgramRestartWithMoreHeap.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import adams.core.management.Launcher;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.UserMode;

/**
 * Restarts the application with 50% more heap.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4568 $
 */
public class ProgramRestartWithMoreHeap
  extends AbstractMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = 7895198900202058018L;

  /**
   * Initializes the menu item with no owner.
   */
  public ProgramRestartWithMoreHeap() {
    this(null);
  }

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public ProgramRestartWithMoreHeap(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Returns the file name of the icon.
   *
   * @return		the filename or null if no icon available
   */
  public String getIconName() {
    return "restart.png";
  }

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    System.exit(Launcher.CODE_RESTART_MORE_HEAP);
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "Restart (more memory)";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return true;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.BASIC;
  }

  /**
   * Returns the category of the menu item in which it should appear, i.e.,
   * the name of the menu.
   *
   * @return		the category/menu name
   */
  public String getCategory() {
    return CATEGORY_PROGRAM;
  }

  /**
   * Returns whether the menu item requires a restartable application.
   *
   * @return		true if a restartable application is required
   */
  public boolean requiresRestartableApplication() {
    return true;
  }
}