/**
 * AbstractDataContainerUpdatingPostProcessor.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.scripting;

import java.io.Serializable;
import java.util.Vector;

import adams.data.container.DataContainer;

/**
 * Abstract ancestor for classes that need to post-process the containers
 * that the container manager got updated with.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1073 $
 */
public abstract class AbstractDataContainerUpdatingPostProcessor
  implements Serializable {

  /** for serialization. */
  private static final long serialVersionUID = 2269820505356261133L;

  /** the owning processor. */
  protected AbstractCommandProcessor m_Owner;

  /**
   * Initializes the post-processor.
   *
   * @param owner	the owning processor
   */
  public AbstractDataContainerUpdatingPostProcessor(AbstractCommandProcessor owner) {
    super();

    m_Owner = owner;
  }

  /**
   * Returns the owning scriptlet.
   *
   * @return		the scriptlet
   */
  public AbstractCommandProcessor getOwner() {
    return m_Owner;
  }

  /**
   * Post-processes the containers.
   *
   * @param conts	the containers to post-process
   */
  public abstract void postProcess(Vector<? extends DataContainer> conts);
}
