/**
 * RunFlow.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.scripting;

import adams.flow.control.SubProcess;

/**
 * Abstract ancestor for scriptlets that run flows and replace the data
 * containers.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 501 $
 */
public class RunFlow
  extends AbstractFlowScriptlet {

  /** for serialization. */
  private static final long serialVersionUID = -2210176790250818043L;

  /** the action to execute. */
  public final static String ACTION = "run-flow";

  /**
   * Returns the action string used in the command processor.
   *
   * @return		the action string
   */
  public String getAction() {
    return ACTION;
  }

  /**
   * Returns the full description of the action.
   *
   * @return		the full description
   */
  public String getDescription() {
    return
        "Executes the flow stored in the given file.\n"
      + "The base actor has to be '" + SubProcess.class.getName() + "'.\n"
      + "The processed " + getOwner().getRequiredFlowClass().getName().replaceAll(".*\\.", "") + "s "
      + "replace the currently loaded ones.";
  }

  /**
   * Processes the options.
   *
   * @param options	additional/optional options for the action
   * @return		null if no error, otherwise error message
   * @throws Exception 	if something goes wrong
   */
  public String process(String options) throws Exception {
    return process(options, false);
  }
}
