/*
 * AbstractContainerTableColumnNameGenerator.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.container;

import java.io.Serializable;

/**
 * Abstract class for generating the column names of a table.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1604 $
 */
public abstract class AbstractContainerTableColumnNameGenerator
  implements Serializable {

  /** for serialization. */
  private static final long serialVersionUID = -335416065314160245L;

  /**
   * Returns the name of the column with the visibility checkbox in it.
   *
   * @return		the name
   */
  public abstract String getVisibility();

  /**
   * Returns the width of the visibility column.
   *
   * @return		the width
   */
  public abstract int getVisibilityWidth();

  /**
   * Returns the name of the column with the database ID in it.
   *
   * @return		the name
   */
  public abstract String getDatabaseID();

  /**
   * Returns the width of the database ID column.
   *
   * @return		the width
   */
  public abstract int getDatabaseIDWidth();

  /**
   * Returns the name of the column with the actual data in it.
   *
   * @return		the name
   */
  public abstract String getData();

  /**
   * Returns the width of the data column.
   *
   * @return		the width
   */
  public abstract int getDataWidth();
}