/*
 * ColorContainer.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.container;

import java.awt.Color;

/**
 * Interface for containers that encapsulate color as well.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 23 $
 */
public interface ColorContainer {
  
  /**
   * Sets the color to use.
   * 
   * @param value	the color
   */
  public void setColor(Color value);
  
  /**
   * Returns the current color in use.
   * 
   * @return		the color
   */
  public Color getColor();
}