/*
 * ReloadableContainerManager.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.container;

/**
 * For container managers that can may be able to reload their contents
 * from the database.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 23 $
 */
public interface ReloadableContainerManager {
  
  /**
   * Sets whether the spectrums are reloadable (from the database) or not.
   * 
   * @param value	true if the spectrums can be reloaded
   */
  public void setReloadable(boolean value);
  
  /**
   * Returns whether the spectrums can be reloaded from the database or not.
   * 
   * @return		true if the spectrums can be reloaded
   */
  public boolean isReloadable();
}
