/**
 * ExternalActor.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.visualization.debug.inspectionhandler;

import java.util.Hashtable;

import adams.flow.core.AbstractExternalActor;

/**
 * Provides further insight into external actors.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3101 $
 */
public class ExternalActor
  extends AbstractInspectionHandler {

  /**
   * Checks whether the handler can handle the specified object.
   *
   * @param obj		the object to check
   * @return		true if the handler can handle this type of object
   */
  public boolean handles(Object obj) {
    return (obj instanceof AbstractExternalActor);
  }

  /**
   * Returns further inspection values.
   *
   * @param obj		the object to further inspect
   * @return		the named inspected values
   */
  public Hashtable<String,Object> inspect(Object obj) {
    Hashtable<String,Object>	result;
    Object			value;

    result = new Hashtable<String,Object>();

    value = ((AbstractExternalActor) obj).getExternalActor();
    if (value != null)
      result.put("external actor", value);

    return result;
  }
}
