/**
 * AbstractImageFilter.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.visualization.image.plugins;

import java.awt.image.BufferedImage;
import java.io.File;

import adams.gui.visualization.image.ImagePanel;

/**
 * Ancestor for plugins that
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3797 $
 */
public abstract class AbstractImageFilter
  extends AbstractImageViewerPlugin {

  /** for serialization. */
  private static final long serialVersionUID = 869121794905442017L;

  /** for storing filtering errors. */
  protected String m_FilterError;

  /**
   * Checks whether the plugin can be executed given the specified image panel.
   * <p/>
   * Panel must be non-null and must contain an image.
   *
   * @param panel	the panel to use as basis for decision
   * @return		true if plugin can be executed
   */
  public boolean canExecute(ImagePanel panel) {
    return (panel != null) && (panel.getCurrentImage() != null);
  }

  /**
   * Filters the image.
   *
   * @param image	the image to filter
   * @return		the processed image
   */
  protected abstract BufferedImage filter(BufferedImage image);

  /**
   * Executes the plugin.
   *
   * @param panel	the panel to use the plugin on
   * @return		null if OK, otherwise error message
   */
  protected String doExecute() {
    String		result;
    BufferedImage	input;
    BufferedImage	output;
    File		file;

    result = null;

    input         = m_CurrentPanel.getCurrentImage();
    m_FilterError = null;
    try {
      output = filter(input);

      // did user abort filtering?
      if (m_CanceledByUser)
	return result;

      if (output == null) {
	result = "Failed to filter image: ";
	if (m_FilterError == null)
	  result += "unknown reason";
	else
	  result += m_FilterError;
      }
      else {
	file = m_CurrentPanel.getCurrentFile();
	m_CurrentPanel.setCurrentImage(output);
	m_CurrentPanel.setCurrentFile(file);
	m_CurrentPanel.setModified(true);
      }
    }
    catch (Exception e) {
      m_FilterError = e.toString();
      result = "Failed to filter image: ";
      getSystemErr().println(result);
      getSystemErr().printStackTrace(e);
      result += m_FilterError;
    }

    return result;
  }
}
