/*
 * XYSequenceStickHitDetector.java
 * Copyright (C) 2009-2010 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.sequence;

import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequenceUtils;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;

/**
 * Detects selections of sequence points in the sequence panel.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2571 $
 */
public class XYSequenceStickHitDetector
  extends AbstractXYSequencePointHitDetector {

  /** for serialization. */
  private static final long serialVersionUID = -6333044496555537078L;

  /**
   * Initializes the hit detector.
   *
   * @param owner	the panel that uses this detector
   */
  public XYSequenceStickHitDetector(XYSequencePanel owner) {
    super(owner);
  }

  /**
   * Checks for a hit.
   *
   * @param e		the MouseEvent (for coordinates)
   * @return		the associated object with the hit, otherwise null
   */
  protected Object isHit(MouseEvent e) {
    double			y;
    double			x;
    double			diffY;
    double			diffX;
    double			diffPixel;
    int				i;
    XYSequence			s;
    XYSequencePoint		sp;
    Vector<XYSequencePoint>	result;
    AxisPanel			axisBottom;
    AxisPanel			axisLeft;
    int				index;
    List<XYSequencePoint>	points;

    result     = new Vector<XYSequencePoint>();
    axisBottom = m_Owner.getPlot().getAxis(Axis.BOTTOM);
    axisLeft   = m_Owner.getPlot().getAxis(Axis.LEFT);
    y          = axisLeft.posToValue((int) e.getY());
    x          = axisBottom.posToValue((int) e.getX());

    for (i = 0; i < m_Owner.getContainerManager().count(); i++) {
      if (!((VisibilityContainer) m_Owner.getContainerManager().get(i)).isVisible())
	continue;

      // check for hit
      s      = m_Owner.getContainerManager().get(i).getData();
      points = s.toList();

      if (getDebug())
	getDebugging().println("\n" + s.getID() + ":");
      index = XYSequenceUtils.findClosestX(points, x);
      if (index == -1)
	continue;
      sp = points.get(index);

      diffX     = sp.getX().doubleValue() - x;
      diffPixel = Math.abs(axisBottom.valueToPos(diffX) - axisBottom.valueToPos(0));
      if (getDebug())
	getDebugging().println("diff x=" + diffPixel);
      if (diffPixel > m_MinimumPixelDifference)
	continue;

      // top
      diffY     = sp.getY().doubleValue() - y;
      diffPixel = axisLeft.valueToPos(diffY) - axisLeft.valueToPos(0);
      if (getDebug())
	getDebugging().println("diff top y=" + diffPixel);
      if (diffPixel > m_MinimumPixelDifference)
	continue;

      // zero
      diffPixel = e.getY() - axisLeft.valueToPos(0);
      if (getDebug())
	getDebugging().println("diff zero y=" + diffPixel);
      if (diffPixel > m_MinimumPixelDifference)
	continue;

      // add hit
      if (getDebug())
	getDebugging().println("hit!");
      result.add(sp);
    }

    if (result.size() > 0)
      return result;
    else
      return null;
  }
}
