/* The following code was generated by JFlex 1.4.2 on 2/16/12 8:01 PM */

/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Scanner.java
 * Copyright (C) 2008,2010 University of Waikato, Hamilton, New Zealand
 */

package adams.parser.mathematicalexpression;

import java_cup.runtime.SymbolFactory;
import java.io.*;

/**
 * A scanner for mathematical expressions.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4534 $
 */

public class Scanner implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\53\1\53\1\0\2\53\22\0\1\53\1\12\3\0\1\6"+
    "\1\13\1\0\1\55\1\56\1\3\1\2\1\54\1\1\1\44\1\4"+
    "\1\43\11\45\2\0\1\7\1\10\1\11\2\0\4\50\1\42\3\50"+
    "\1\41\4\50\1\47\1\50\1\40\12\50\1\51\1\0\1\52\1\5"+
    "\2\0\1\22\1\25\1\35\1\0\1\20\1\21\1\30\1\0\1\33"+
    "\2\0\1\23\1\37\1\34\1\27\1\32\1\26\1\16\1\24\1\15"+
    "\1\17\1\0\1\36\1\31\1\46\2\0\1\14\uff83\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\12\1\2\16"+
    "\1\17\1\20\2\16\1\1\1\21\1\22\1\23\1\24"+
    "\1\0\1\25\1\26\1\27\17\0\1\30\2\0\1\20"+
    "\4\0\1\31\1\0\1\32\2\0\1\33\1\34\1\0"+
    "\1\35\1\36\4\0\1\37\2\0\1\20\1\40\1\41"+
    "\1\0\1\42\1\43\2\0\1\44\3\0\1\45\2\0"+
    "\1\46\1\47\5\0\1\50\1\0\1\51\6\0\1\52"+
    "\1\53\1\54";

  private static int [] zzUnpackAction() {
    int [] result = new int[113];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\57\0\136\0\57\0\57\0\57\0\57\0\57"+
    "\0\215\0\57\0\274\0\353\0\57\0\57\0\u011a\0\u0149"+
    "\0\u0178\0\u01a7\0\u01d6\0\u0205\0\u0234\0\u0263\0\u0292\0\u02c1"+
    "\0\u02f0\0\u031f\0\u034e\0\u037d\0\u03ac\0\u034e\0\u03db\0\57"+
    "\0\57\0\57\0\57\0\u040a\0\57\0\57\0\57\0\u0439"+
    "\0\u0468\0\u0497\0\u04c6\0\u04f5\0\u0524\0\u0553\0\u0582\0\u05b1"+
    "\0\u05e0\0\u060f\0\u063e\0\u066d\0\u069c\0\u06cb\0\u034e\0\u06fa"+
    "\0\u0729\0\u0758\0\u0787\0\u07b6\0\u07e5\0\u0814\0\57\0\u0843"+
    "\0\57\0\u0872\0\u08a1\0\57\0\57\0\u08d0\0\57\0\57"+
    "\0\u08ff\0\u092e\0\u095d\0\u098c\0\57\0\u09bb\0\u09ea\0\u0a19"+
    "\0\57\0\57\0\u0a48\0\57\0\57\0\u0a77\0\u0aa6\0\57"+
    "\0\u0ad5\0\u0b04\0\u0b33\0\57\0\u0b62\0\u0b91\0\57\0\57"+
    "\0\u0bc0\0\u0bef\0\u0c1e\0\u0c4d\0\u0c7c\0\57\0\u0cab\0\57"+
    "\0\u0cda\0\u0d09\0\u0d38\0\u0d67\0\u0d96\0\u0dc5\0\57\0\57"+
    "\0\57";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[113];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11"+
    "\1\12\1\13\1\14\1\15\1\16\1\17\1\20\1\2"+
    "\1\21\1\22\1\23\1\24\1\25\5\2\1\26\1\27"+
    "\1\2\1\30\2\2\1\31\1\32\1\33\1\34\1\2"+
    "\1\34\1\2\1\35\1\36\1\37\1\2\1\40\1\41"+
    "\1\42\1\43\120\0\1\44\25\0\1\45\56\0\1\46"+
    "\56\0\1\47\64\0\1\50\3\0\1\51\67\0\1\52"+
    "\54\0\1\53\47\0\1\54\1\55\60\0\1\56\60\0"+
    "\1\57\55\0\1\60\4\0\1\61\52\0\1\62\50\0"+
    "\1\63\2\0\1\64\52\0\1\65\6\0\1\66\67\0"+
    "\1\36\1\67\1\36\4\0\2\36\42\0\1\70\3\0"+
    "\3\36\4\0\2\36\46\0\3\36\4\0\2\36\50\0"+
    "\1\71\1\34\1\72\1\34\33\0\1\73\15\0\3\36"+
    "\4\0\2\36\6\0\52\74\1\0\4\74\34\0\1\75"+
    "\41\0\1\76\73\0\1\77\56\0\1\100\54\0\1\101"+
    "\47\0\1\102\62\0\1\103\53\0\1\104\62\0\1\105"+
    "\44\0\1\106\74\0\1\107\60\0\1\110\40\0\1\111"+
    "\16\0\1\112\34\0\1\113\74\0\1\114\47\0\1\115"+
    "\53\0\1\116\36\0\1\117\43\0\1\120\53\0\1\71"+
    "\1\72\1\0\1\72\60\0\1\121\7\0\52\74\1\122"+
    "\4\74\21\0\1\123\55\0\1\124\53\0\1\125\65\0"+
    "\1\126\61\0\1\127\44\0\1\130\64\0\1\131\66\0"+
    "\1\132\41\0\1\133\63\0\1\134\66\0\1\135\70\0"+
    "\1\120\54\0\1\120\1\0\1\120\44\0\1\136\43\0"+
    "\1\137\54\0\1\140\64\0\1\141\56\0\1\142\51\0"+
    "\1\143\73\0\1\144\56\0\1\145\42\0\1\146\62\0"+
    "\1\147\52\0\1\150\71\0\1\151\56\0\1\152\56\0"+
    "\1\153\40\0\1\154\56\0\1\155\75\0\1\156\70\0"+
    "\1\157\56\0\1\160\40\0\1\161\26\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[3572];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\1\1\5\11\1\1\1\11\2\1\2\11"+
    "\21\1\4\11\1\0\3\11\17\0\1\1\2\0\1\1"+
    "\4\0\1\11\1\0\1\11\2\0\2\11\1\0\2\11"+
    "\4\0\1\11\2\0\1\1\2\11\1\0\2\11\2\0"+
    "\1\11\3\0\1\11\2\0\2\11\5\0\1\11\1\0"+
    "\1\11\6\0\3\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[113];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
  // Author: FracPete (fracpete at waikato dot ac dot nz)
  // Version: $Revision: 4534 $
  protected SymbolFactory sf;

  public Scanner(InputStream r, SymbolFactory sf){
    this(r);
    this.sf = sf;
  }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Scanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Scanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 136) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 23: 
          { return sf.newSymbol("Not qquals", sym.NOT_EQ);
          }
        case 45: break;
        case 27: 
          { return sf.newSymbol("Abs", sym.ABS);
          }
        case 46: break;
        case 44: 
          { return sf.newSymbol("IfMissing", sym.IFMISSING);
          }
        case 47: break;
        case 15: 
          { return sf.newSymbol("e", sym.E);
          }
        case 48: break;
        case 29: 
          { return sf.newSymbol("Sin", sym.SIN);
          }
        case 49: break;
        case 17: 
          { /* ignore white space. */
          }
        case 50: break;
        case 18: 
          { return sf.newSymbol("Comma", sym.COMMA);
          }
        case 51: break;
        case 14: 
          { return sf.newSymbol("Variable", sym.VARIABLE, new String(yytext()));
          }
        case 52: break;
        case 40: 
          { return sf.newSymbol("IfElse", sym.IFELSE);
          }
        case 53: break;
        case 4: 
          { return sf.newSymbol("Times", sym.TIMES);
          }
        case 54: break;
        case 33: 
          { return sf.newSymbol("Variable", sym.VARIABLE, new String(yytext().replace("[", "").replace("]", "")));
          }
        case 55: break;
        case 39: 
          { return sf.newSymbol("Floor", sym.FLOOR);
          }
        case 56: break;
        case 38: 
          { return sf.newSymbol("False", sym.FALSE);
          }
        case 57: break;
        case 16: 
          { return sf.newSymbol("Number", sym.NUMBER, new Double(yytext()));
          }
        case 58: break;
        case 30: 
          { return sf.newSymbol("Pow", sym.POW);
          }
        case 59: break;
        case 8: 
          { return sf.newSymbol("Less than", sym.LT);
          }
        case 60: break;
        case 37: 
          { return sf.newSymbol("Ceil", sym.CEIL);
          }
        case 61: break;
        case 20: 
          { return sf.newSymbol("Right Bracket", sym.RPAREN);
          }
        case 62: break;
        case 25: 
          { return sf.newSymbol("Tan", sym.TAN);
          }
        case 63: break;
        case 34: 
          { return sf.newSymbol("True", sym.TRUE);
          }
        case 64: break;
        case 9: 
          { return sf.newSymbol("Equals", sym.EQ);
          }
        case 65: break;
        case 32: 
          { return sf.newSymbol("Number", sym.NUMBER, new Double(Double.NaN));
          }
        case 66: break;
        case 6: 
          { return sf.newSymbol("Power", sym.EXPONENT);
          }
        case 67: break;
        case 22: 
          { return sf.newSymbol("Greater or equal than", sym.GE);
          }
        case 68: break;
        case 31: 
          { return sf.newSymbol("Cos", sym.COS);
          }
        case 69: break;
        case 36: 
          { return sf.newSymbol("Sqrt", sym.SQRT);
          }
        case 70: break;
        case 28: 
          { return sf.newSymbol("Log", sym.LOG);
          }
        case 71: break;
        case 24: 
          { return sf.newSymbol("pi", sym.PI);
          }
        case 72: break;
        case 41: 
          { return sf.newSymbol("IsTrue", sym.ISTRUE);
          }
        case 73: break;
        case 2: 
          { return sf.newSymbol("Minus", sym.MINUS);
          }
        case 74: break;
        case 3: 
          { return sf.newSymbol("Plus", sym.PLUS);
          }
        case 75: break;
        case 35: 
          { return sf.newSymbol("Rint", sym.RINT);
          }
        case 76: break;
        case 7: 
          { return sf.newSymbol("Modulo", sym.MODULO);
          }
        case 77: break;
        case 21: 
          { return sf.newSymbol("Less or equal than", sym.LE);
          }
        case 78: break;
        case 19: 
          { return sf.newSymbol("Left Bracket", sym.LPAREN);
          }
        case 79: break;
        case 43: 
          { return sf.newSymbol("Number", sym.NUMBER, new Double(Double.NEGATIVE_INFINITY));
          }
        case 80: break;
        case 26: 
          { return sf.newSymbol("Exp", sym.EXP);
          }
        case 81: break;
        case 5: 
          { return sf.newSymbol("Division", sym.DIVISION);
          }
        case 82: break;
        case 1: 
          { System.err.println("Illegal character: "+yytext());
          }
        case 83: break;
        case 42: 
          { return sf.newSymbol("Number", sym.NUMBER, new Double(Double.POSITIVE_INFINITY));
          }
        case 84: break;
        case 11: 
          { return sf.newSymbol("Not", sym.NOT);
          }
        case 85: break;
        case 13: 
          { return sf.newSymbol("Or", sym.OR);
          }
        case 86: break;
        case 10: 
          { return sf.newSymbol("Greater than", sym.GT);
          }
        case 87: break;
        case 12: 
          { return sf.newSymbol("And", sym.AND);
          }
        case 88: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {     return sf.newSymbol("EOF",sym.EOF);
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
