/*
 * InitializeTables.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.tools;

import adams.db.AbstractDatabaseConnection;
import adams.db.AbstractIndexedTable;
import adams.db.DatabaseConnection;

/**
 <!-- globalinfo-start -->
 * Makes sure that all tables exist and are initialized. Can be called at runtime to re-create tables that got dropped.
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D (property: debug)
 *         If set to true, scheme may output additional info to the console.
 * </pre>
 *
 * <pre>-driver &lt;java.lang.String&gt; (property: driver)
 *         The JDBC driver.
 *         default: com.mysql.jdbc.Driver
 * </pre>
 *
 * <pre>-url &lt;java.lang.String&gt; (property: URL)
 *         The database URL.
 * </pre>
 *
 * <pre>-user &lt;java.lang.String&gt; (property: user)
 *         The database user.
 * </pre>
 *
 * <pre>-password &lt;java.lang.String&gt; (property: password)
 *         The password of the database user.
 * </pre>
 *
 <!-- options-end -->
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 */
public class InitializeTables
  extends AbstractDatabaseTool {

  /** for serialization. */
  private static final long serialVersionUID = 1052968728531351369L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return
        "Makes sure that all tables exist and are initialized. Can be "
      + "called at runtime to re-create tables that got dropped.";
  }

  /**
   * Returns the default database connection.
   *
   * @return		the database connection
   */
  protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
    return DatabaseConnection.getSingleton();
  }

  /**
   * Attempt to load the file and save to db.
   * Exit java upon failure
   */
  protected void doRun() {
    AbstractIndexedTable.initTables(getDatabaseConnection());
  }
}
