/**
 * NestedConsumerTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

import java.util.Arrays;
import java.util.Vector;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractActor;
import adams.parser.MathematicalExpressionText;

/**
 * Tests the NestedConsumer class.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4563 $
 */
public class NestedConsumerTest
  extends AbstractOptionConsumerTestCase<Vector> {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public NestedConsumerTest(String name) {
    super(name);
  }

  /**
   * Tests a simple option handler.
   */
  public void testConsumeSimple() {
    adams.flow.sink.DumpFile handler = new adams.flow.sink.DumpFile();
    handler.setDebugLevel(1);
    handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
    handler.setAppend(true);

    Vector input = new Vector();
    input.add("adams.flow.sink.DumpFile");
    Vector options = new Vector();
    input.add(options);
    options.addAll(Arrays.asList(new String[]{
	"-D",
	"1",
	"-output",
	"${TMP}/dumpfile.csv",
	"-append"
    }));

    performInputTest(new NestedConsumer(), input, handler);
  }

  /**
   * Tests generating a simple option handler from a string.
   */
  public void testFromStringSimple() {
    adams.flow.sink.DumpFile handler = new adams.flow.sink.DumpFile();
    handler.setDebugLevel(1);
    handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
    handler.setAppend(true);

    performFromStringTest(
	NestedConsumer.class,
	  "adams.flow.sink.DumpFile\n"
	+ "\t-D\n"
	+ "\t1\n"
	+ "\t-output\n"
	+ "\t${TMP}/dumpfile.csv\n"
	+ "\t-append\n",
	handler);
  }

  /**
   * Tests a deeply nested option handler.
   */
  public void testConsumeDeep() {
    adams.data.filter.MultiFilter handler = new adams.data.filter.MultiFilter();
    handler.setDebugLevel(1);
    adams.data.filter.AbstractFilter[] filters = new adams.data.filter.AbstractFilter[2];
    filters[0] = new adams.data.filter.PassThrough();
    filters[0].setDebugLevel(2);
    filters[1] = new adams.data.filter.MultiFilter();
    filters[1].setDebugLevel(3);
    handler.setSubFilters(filters);

    Vector input = new Vector();
    input.add("adams.data.filter.MultiFilter");
    Vector options = new Vector();
    input.add(options);
    options.add("-D");
    options.add("1");

    options.add("-filter");
    Vector filter1 = new Vector();
    options.add(filter1);
    filter1.add("adams.data.filter.PassThrough");
    Vector options1 = new Vector();
    filter1.add(options1);
    options1.add("-D");
    options1.add("2");

    options.add("-filter");
    Vector filter2 = new Vector();
    options.add(filter2);
    filter2.add("adams.data.filter.MultiFilter");
    Vector options2 = new Vector();
    filter2.add(options2);
    options2.add("-D");
    options2.add("3");
    options2.add("-filter");
    Vector filter3 = new Vector();
    options2.add(filter3);
    filter3.add("adams.data.filter.PassThrough");

    performInputTest(new NestedConsumer(), input, handler);
  }

  /**
   * Tests generating a deeply nested option handler from a string.
   */
  public void testFromStringDeep() {
    adams.data.filter.MultiFilter handler = new adams.data.filter.MultiFilter();
    handler.setDebugLevel(1);
    adams.data.filter.AbstractFilter[] filters = new adams.data.filter.AbstractFilter[2];
    filters[0] = new adams.data.filter.PassThrough();
    filters[0].setDebugLevel(2);
    filters[1] = new adams.data.filter.MultiFilter();
    filters[1].setDebugLevel(3);
    handler.setSubFilters(filters);

    performFromStringTest(
	NestedConsumer.class,
	  "adams.data.filter.MultiFilter\n"
	+ "\t-D\n"
	+ "\t1\n"
	+ "\t-filter\n"
	+ "\t\tadams.data.filter.PassThrough\n"
	+ "\t\t\t-D\n"
	+ "\t\t\t2\n"
	+ "\t-filter\n"
	+ "\t\tadams.data.filter.MultiFilter\n"
	+ "\t\t\t-D\n"
	+ "\t\t\t3\n"
	+ "\t\t\t-filter\n"
	+ "\t\t\t\tadams.data.filter.PassThrough\n",
	handler);
  }

  /**
   * Tests another deeply nested option handler.
   */
  public void testConsumeDeep2() {
    adams.data.filter.BaselineCorrection handler = new adams.data.filter.BaselineCorrection();
    adams.data.baseline.SlidingWindow baselineObj = new adams.data.baseline.SlidingWindow();
    baselineObj.setDebugLevel(2);
    handler.setBaselineCorrection(baselineObj);

    Vector input = new Vector();
    input.add("adams.data.filter.BaselineCorrection");
    Vector options = new Vector();
    input.add(options);
    options.add("-baseline");
    Vector baseline = new Vector();
    options.add(baseline);
    baseline.add("adams.data.baseline.SlidingWindow");
    Vector optionsBase = new Vector();
    baseline.add(optionsBase);
    optionsBase.add("-D");
    optionsBase.add("2");
    optionsBase.add("-baseline");
    Vector baseline2 = new Vector();
    optionsBase.add(baseline2);
    baseline2.add("adams.data.baseline.PassThrough");

    performInputTest(new NestedConsumer(), input, handler);
  }

  /**
   * Tests generating another deeply nested option handler from a string.
   */
  public void testFromStringDeep2() {
    adams.data.filter.BaselineCorrection handler = new adams.data.filter.BaselineCorrection();
    adams.data.baseline.SlidingWindow baseline = new adams.data.baseline.SlidingWindow();
    baseline.setDebugLevel(2);
    handler.setBaselineCorrection(baseline);

    performFromStringTest(
	NestedConsumer.class,
	  "adams.data.filter.BaselineCorrection\n"
	+ "\t-baseline\n"
	+ "\t\tadams.data.baseline.SlidingWindow\n"
	+ "\t\t\t-D\n"
	+ "\t\t\t2\n"
	+ "\t\t\t-baseline\n"
	+ "\t\t\t\tadams.data.baseline.PassThrough\n",
	handler);
  }

  /**
   * Tests generating another deeply nested option handler from a string.
   */
  public void testFromStringDeep3() {
    adams.flow.control.Flow handler = new adams.flow.control.Flow();
    adams.flow.source.StringConstants sc = new adams.flow.source.StringConstants();
    sc.setStrings(new BaseString[]{
	new BaseString("1"),
	new BaseString("2"),
	new BaseString("3")
    });
    adams.data.conversion.StringToDouble s2d = new adams.data.conversion.StringToDouble();
    adams.flow.transformer.Convert con = new adams.flow.transformer.Convert();
    con.setConversion(s2d);
    adams.flow.transformer.MathExpression me = new adams.flow.transformer.MathExpression();
    me.setExpression(new MathematicalExpressionText("X^2"));
    adams.flow.sink.DumpFile df = new adams.flow.sink.DumpFile();
    df.setAppend(true);
    df.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.txt"));
    handler.setActors(new AbstractActor[]{
	sc,
	con,
	me,
	df
    });

    performFromStringTest(
	NestedConsumer.class,
	  "adams.flow.control.Flow\n"
	+ "\t-actor\n"
	+ "\t\tadams.flow.source.StringConstants\n"
	+ "\t\t\t-string\n"
	+ "\t\t\t1\n"
	+ "\t\t\t-string\n"
	+ "\t\t\t2\n"
	+ "\t\t\t-string\n"
	+ "\t\t\t3\n"
	+ "\t-actor\n"
	+ "\t\tadams.flow.transformer.Convert\n"
	+ "\t\t\t-conversion\n"
	+ "\t\t\t\tadams.data.conversion.StringToDouble\n"
	+ "\t-actor\n"
	+ "\t\tadams.flow.transformer.MathExpression\n"
	+ "\t\t\t-expression\n"
	+ "\t\t\tX^2\n"
	+ "\t-actor\n"
	+ "\t\tadams.flow.sink.DumpFile\n"
	+ "\t\t\t-output\n"
	+ "\t\t\t${TMP}/dumpfile.txt\n"
	+ "\t\t\t-append\n",
	handler);
  }
}
