/**
 * LeftPadTest.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */

package adams.data.conversion;

import adams.data.conversion.LeftPad;
import adams.test.TmpFile;

/**
 * Tests the LeftPad conversion.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4376 $
 */
public class LeftPadTest
  extends AbstractConversionTestCase {

  /**
   * Constructs the test case. Called by subclasses.
   *
   * @param name 	the name of the test
   */
  public LeftPadTest(String name) {
    super(name);
  }

  /**
   * Returns the input data to use in the regression test.
   *
   * @return		the objects
   */
  protected Object[] getRegressionInput() {
    return new String[]{
	"1",
	"12",
	"123",
	"1234",
	"12345",
	"123456",
	"1234567"
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected AbstractConversion[] getRegressionSetups() {
    LeftPad[]	result;

    result    = new LeftPad[2];
    result[0] = new LeftPad();
    result[1] = new LeftPad();
    result[1].setWidth(5);

    return result;
  }

  /**
   * Returns the ignored line indices to use in the regression test.
   *
   * @return		the setups
   */
  protected int[] getRegressionIgnoredLineIndices() {
    return new int[0];
  }
}
