/*
 * ReportFileWriterTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.flow.transformer;

import java.io.File;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.output.DefaultSimpleCSVReportWriter;
import adams.data.io.output.DefaultSimpleReportWriter;
import adams.flow.AbstractFlowTest;
import adams.flow.standalone.DatabaseConnection;
import adams.core.io.FixedFilenameGenerator;
import adams.core.io.PlaceholderDirectory;
import adams.env.Environment;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.source.SingleFileSupplier;
import adams.test.TmpFile;
import adams.test.TmpDirectory;

/**
 * Tests the ReportFileReader/Writer actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3974 $
 */
public class ReportFileWriterTest
  extends AbstractFlowTest {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public ReportFileWriterTest(String name) {
    super(name);
  }

  /**
   * Called by JUnit before each test method. Copies some tmp files.
   *
   * @throws Exception if an error occurs reading the example instances.
   */
  protected void setUp() throws Exception {
    super.setUp();

    m_TestHelper.copyResourceToTmp("simple.report");
  }

  /**
   * Called by JUnit after each test method.
   *
   * @throws Exception	if tear-down fails
   */
  protected void tearDown() throws Exception {
    m_TestHelper.deleteFileFromTmp("out.csv");
    m_TestHelper.deleteFileFromTmp("simple.report");

    super.tearDown();
  }

  /**
   * Used to create an instance of a specific actor.
   *
   * @return a suitably configured <code>AbstractActor</code> value
   */
  public AbstractActor getActor() {
    DatabaseConnection dbcon = new DatabaseConnection();
    dbcon.setURL(getDatabaseURL());
    dbcon.setUser(getDatabaseUser());
    dbcon.setPassword(getDatabasePassword());

    SingleFileSupplier sfs = new SingleFileSupplier();
    sfs.setFile(new TmpFile("simple.report"));

    DefaultSimpleReportReader reader = new DefaultSimpleReportReader();
    ReportFileReader fr = new ReportFileReader();
    fr.setReader(reader);

    DefaultSimpleCSVReportWriter writer = new DefaultSimpleCSVReportWriter();
    FixedFilenameGenerator ffg = new FixedFilenameGenerator();
    ffg.setName("out.csv");
    ffg.setDirectory(new TmpDirectory());
    ReportFileWriter fw = new ReportFileWriter();
    fw.setWriter(writer);
    fw.setFilenameGenerator(ffg);
    fw.setOutputDir(new PlaceholderDirectory(m_TestHelper.getTmpDirectory()));

    Flow flow = new Flow();
    flow.setActors(new AbstractActor[]{dbcon, sfs, fr, fw});

    return flow;
  }

  /**
   * Performs a regression test, comparing against previously generated output.
   */
  public void testRegression() {
    performRegressionTest(
	new File[]{
	    new TmpFile("out.csv")});
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(ReportFileWriterTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args){
    Environment.setEnvironmentClass(adams.env.Environment.class);
    runTest(suite());
  }
}
