/**
 * MathematicalExpressionTest.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.parser;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.core.base.BaseString;
import adams.env.Environment;

/**
 * Tests the adams.parser.MathematicalExpression class. Run from commandline with: <p/>
 * java adams.parser.MathematicalExpressionTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4534 $
 */
public class MathematicalExpressionTest
  extends AbstractSymbolEvaluatorTestCase<Double, MathematicalExpression> {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public MathematicalExpressionTest(String name) {
    super(name);
  }

  /**
   * Returns the symbols used in the regression test.
   *
   * @return		the symbols
   */
  protected BaseString[][][] getRegressionSymbols() {
    return new BaseString[][][]{
	{
	  {/** no symbols. */},		//  1
	  {/** no symbols. */},		//  2
	  {/** no symbols. */},		//  3
	  {/** no symbols. */},		//  4
	  {new BaseString("X=2.0")},	//  5
	  {new BaseString("X=2.0")},	//  6
	  {new BaseString("X=2.0")},	//  7
	  {new BaseString("X=1.0")},	//  8
	  {new BaseString("X=1.0")},	//  9
	  {new BaseString("X=1.0")},	// 10
	  {new BaseString("X=1.0")},	// 11
	  {new BaseString("X=1.0")},	// 12
	  {new BaseString("X=1.0")},	// 13
	  {new BaseString("X=3.1")},	// 14
	  {new BaseString("X=2.3")},	// 15
	  {new BaseString("X=1.0")},	// 16
	  {new BaseString("X=-1.0")},	// 17
	  {new BaseString("X=9.0")},	// 18
	  {new BaseString("X=-1.0")},	// 19
	  {new BaseString("X=-1.0")},	// 20
	  {new BaseString("X=-1.0")},	// 21
	  {new BaseString("X=2.0")},	// 22
	  {new BaseString("X=2.0")},	// 23
	  {/** no symbols. */},		// 24
	  {/** no symbols. */},		// 25
	  {/** no symbols. */},		// 26
	  {/** no symbols. */},		// 27
	  {new BaseString("X=2.0")},	// 23
	  {/** no symbols. */},		// 27
	}
    };
  }

  /**
   * Returns the expressions used in the regression test.
   *
   * @return		the data
   */
  protected String[][] getRegressionExpressions() {
    return new String[][]{
	{
	  "1 + 2",			//  1
	  "1 - 2",			//  2
	  "3 * 2",			//  3
	  "1 / 2",			//  4
	  "2 ^ X",			//  5
	  "abs(-10.4 + X)",		//  6
	  "sqrt(X*1.3)",		//  7
	  "log(X + 2)",			//  8
	  "exp(3*100-2)",		//  9
	  "sin(X)",			// 10
	  "cos(X + 1.1)",		// 11
	  "tan(X)",			// 12
	  "rint(X)",			// 13
	  "floor(X * 10)",		// 14
	  "pow(3, X)",			// 15
	  "ceil(X/2)",			// 16
	  "ifelse(X < 0, X^2, X*2)",	// 17
	  "1/sqrt(2*PI*pow(0.5,2))*exp(-pow(X-10,2)/(2*0.5))",	// 18
	  "ifelse(X < 0, X, -X)",	// 19
	  "(ifelse(X < 0, X, -X))",	// 20
	  "ifelse((X < 0), X, -X)",	// 21
	  "(2 ^ X)",			// 22
	  "1/sqrt(2*PI*pow(1.0,2))*exp(-1*pow(X-0,2)/(2*1.0))",	// 23
	  "10 % 3",			// 24
	  "-2^2",			// 25
	  "ifelse(1 != 1, 0, 1)",	// 26
	  "ifelse(2 != 1, 0, 1)",	// 27
	  "ifmissing(X, 0)",		// 28
	  "ifmissing(Y, 0)",		// 29
	}
    };
  }

  /**
   * Returns the setups to use in the regression test.
   *
   * @return		the setups
   */
  protected MathematicalExpression[] getRegressionSetups() {
    return new MathematicalExpression[]{new MathematicalExpression()};
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(MathematicalExpressionTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
