/*
 * MathematicalExpressionTextTest.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */

package adams.parser;

import junit.framework.Test;
import junit.framework.TestSuite;
import adams.env.Environment;
import adams.core.base.AbstractBaseObjectTestCase;

/**
 * Tests the adams.parser.MathematicalExpressionText class. Run from commandline with: <p/>
 * java adams.parser.MathematicalExpressionTextTest
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4563 $
 */
public class MathematicalExpressionTextTest
  extends AbstractBaseObjectTestCase<MathematicalExpressionText> {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public MathematicalExpressionTextTest(String name) {
    super(name);
  }

  /**
   * Returns a default base object.
   *
   * @return		the default object
   */
  protected MathematicalExpressionText getDefault() {
    return new MathematicalExpressionText();
  }

  /**
   * Returns a base object initialized with the given string.
   *
   * @param s		the string to initialize the object with
   * @return		the custom object
   */
  protected MathematicalExpressionText getCustom(String s) {
    return new MathematicalExpressionText(s);
  }

  /**
   * Returns the string representing a typical value to parse that doesn't
   * fail.
   *
   * @return		the value
   */
  protected String getTypicalValue() {
    return "exp(2, 10)";
  }

  /**
   * Returns a test suite.
   *
   * @return		the test suite
   */
  public static Test suite() {
    return new TestSuite(MathematicalExpressionTextTest.class);
  }

  /**
   * Runs the test from commandline.
   *
   * @param args	ignored
   */
  public static void main(String[] args) {
    Environment.setEnvironmentClass(Environment.class);
    runTest(suite());
  }
}
