/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Variables;
import adams.core.base.BaseRegExp;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestSuite;

public class VariablesTest
extends AdamsTestCase {
    public VariablesTest(String name) {
        super(name);
    }

    public void testIsValid() {
        String s = "@{hello}";
        VariablesTest.assertTrue((String)s, (boolean)Variables.isValidName((String)s));
        s = "@{hello-world}";
        VariablesTest.assertTrue((String)s, (boolean)Variables.isValidName((String)s));
        s = "@{hello_world}";
        VariablesTest.assertTrue((String)s, (boolean)Variables.isValidName((String)s));
        s = "@{HELLO_world}";
        VariablesTest.assertTrue((String)s, (boolean)Variables.isValidName((String)s));
        s = "@{hello_world_YOU_2}";
        VariablesTest.assertTrue((String)s, (boolean)Variables.isValidName((String)s));
        s = "@{2_for_1}";
        VariablesTest.assertTrue((String)s, (boolean)Variables.isValidName((String)s));
        s = "@{!hello}";
        VariablesTest.assertFalse((String)s, (boolean)Variables.isValidName((String)s));
        s = "@{hello world}";
        VariablesTest.assertFalse((String)s, (boolean)Variables.isValidName((String)s));
    }

    public void testIsPlaceholder() {
        String s = "@{hello}";
        VariablesTest.assertTrue((String)s, (boolean)Variables.isPlaceholder((String)s));
        s = "@{hello-world}";
        VariablesTest.assertTrue((String)s, (boolean)Variables.isPlaceholder((String)s));
        s = "@{hello_world}";
        VariablesTest.assertTrue((String)s, (boolean)Variables.isPlaceholder((String)s));
        s = "@{hello";
        VariablesTest.assertFalse((String)s, (boolean)Variables.isPlaceholder((String)s));
        s = "@ {hello}";
        VariablesTest.assertFalse((String)s, (boolean)Variables.isPlaceholder((String)s));
        s = "{hello}";
        VariablesTest.assertFalse((String)s, (boolean)Variables.isPlaceholder((String)s));
        s = "hello}";
        VariablesTest.assertFalse((String)s, (boolean)Variables.isPlaceholder((String)s));
        s = "hello";
        VariablesTest.assertFalse((String)s, (boolean)Variables.isPlaceholder((String)s));
        s = "hello world";
        VariablesTest.assertFalse((String)s, (boolean)Variables.isPlaceholder((String)s));
    }

    public void testExtractName() {
        String s = "@{hello}";
        VariablesTest.assertEquals((String)s, (String)"hello", (String)Variables.extractName((String)s));
        s = "hello";
        VariablesTest.assertEquals((String)s, (String)"hello", (String)Variables.extractName((String)s));
        s = "@{hello";
        VariablesTest.assertEquals((String)s, (String)"@{hello", (String)Variables.extractName((String)s));
        s = "@ {hello}";
        VariablesTest.assertEquals((String)s, (String)"@ {hello}", (String)Variables.extractName((String)s));
        s = "@hello}";
        VariablesTest.assertEquals((String)s, (String)"@hello}", (String)Variables.extractName((String)s));
        s = "hello}";
        VariablesTest.assertEquals((String)s, (String)"hello}", (String)Variables.extractName((String)s));
    }

    public void testPadName() {
        String s = "@{hello}";
        VariablesTest.assertEquals((String)s, (String)"@{hello}", (String)Variables.padName((String)s));
        s = "hello";
        VariablesTest.assertEquals((String)s, (String)"@{hello}", (String)Variables.padName((String)s));
    }

    public void testClear() {
        Variables v = new Variables();
        v.set("hello", "world");
        VariablesTest.assertEquals((String)"size filled", (int)1, (int)v.size());
        v.clear();
        VariablesTest.assertEquals((String)"size filled", (int)0, (int)v.size());
    }

    public void testSetGetHas() {
        Variables v = new Variables();
        VariablesTest.assertFalse((boolean)v.has("hello"));
        v.set("hello", "world");
        VariablesTest.assertEquals((String)"size after set", (int)1, (int)v.size());
        VariablesTest.assertTrue((boolean)v.has("hello"));
        VariablesTest.assertEquals((String)"get after set", (String)"world", (String)v.get("hello"));
        v.set("hello", "world2");
        VariablesTest.assertEquals((String)"size after same set", (int)1, (int)v.size());
        VariablesTest.assertTrue((boolean)v.has("hello"));
        VariablesTest.assertEquals((String)"get after set", (String)"world2", (String)v.get("hello"));
        VariablesTest.assertFalse((boolean)v.has("hello2"));
        v.set("hello2", "world3");
        VariablesTest.assertEquals((String)"size after another set", (int)2, (int)v.size());
        VariablesTest.assertTrue((boolean)v.has("hello2"));
        VariablesTest.assertEquals((String)"get after set", (String)"world2", (String)v.get("hello"));
        VariablesTest.assertEquals((String)"get after set", (String)"world3", (String)v.get("hello2"));
    }

    public void testRemove() {
        Variables v = new Variables();
        v.set("hello", "world");
        v.set("hello2", "world2");
        v.set("hello3", "world3");
        VariablesTest.assertEquals((String)"size after initial sets", (int)3, (int)v.size());
        v.remove("blah");
        VariablesTest.assertEquals((String)"size after unsuccessful remove", (int)3, (int)v.size());
        v.remove("hello");
        VariablesTest.assertEquals((String)"size after successful remove", (int)2, (int)v.size());
        v.set("hello", "world");
        v.remove(new BaseRegExp("hello[0-9]"));
        VariablesTest.assertEquals((String)"size after successful remove/regexp", (int)1, (int)v.size());
    }

    public void testExpand() {
        Variables v = new Variables();
        v.set("hello", "world");
        v.set("hello2", "world2");
        v.set("hello3", "world3");
        String s = "hello";
        VariablesTest.assertEquals((String)s, (String)"hello", (String)v.expand(s));
        s = "@{hello2}";
        VariablesTest.assertEquals((String)s, (String)"world2", (String)v.expand(s));
        s = " @{hello2} / @{hello3}";
        VariablesTest.assertEquals((String)s, (String)" world2 / world3", (String)v.expand(s));
        s = " @{hello2} / @{hello3} / @ {hello2} / {hello3} / @{hello / @hello3";
        VariablesTest.assertEquals((String)s, (String)" world2 / world3 / @ {hello2} / {hello3} / @{hello / @hello3", (String)v.expand(s));
    }

    public void testGetClone() {
        Variables v = new Variables();
        v.set("hello", "world");
        v.set("hello2", "world2");
        v.set("hello3", "world3");
        Variables vc = v.getClone();
        VariablesTest.assertEquals((String)"size after clone", (int)v.size(), (int)vc.size());
        Enumeration names = v.names();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            VariablesTest.assertTrue((String)("cloned variable: " + name), (boolean)vc.has(name));
            VariablesTest.assertEquals((String)("cloned variable: " + name), (String)v.get(name), (String)vc.get(name));
        }
        int size = v.size();
        v.clear();
        VariablesTest.assertEquals((String)"size after clear() of original (clone)", (int)size, (int)vc.size());
        VariablesTest.assertEquals((String)"size after clear() of original (original)", (int)0, (int)v.size());
    }

    public static Test suite() {
        return new TestSuite(VariablesTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        VariablesTest.runTest(VariablesTest.suite());
    }
}

