/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.random.AbstractRandomNumberGenerator;
import adams.data.random.JavaRandomInt;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.control.StorageName;
import adams.flow.control.Trigger;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.RandomNumberGenerator;
import adams.flow.source.StorageValue;
import adams.flow.transformer.SetStorageValue;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SetStorageValueTest
extends AbstractFlowTest {
    public SetStorageValueTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        rng.setGenerator((AbstractRandomNumberGenerator)new JavaRandomInt());
        rng.setMaxNum(100);
        SetStorageValue ssv = new SetStorageValue();
        ssv.setStorageName(new StorageName("rand"));
        StorageValue sv = new StorageValue();
        sv.setStorageName(new StorageName("rand"));
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Sequence seq = new Sequence();
        seq.setActors(new AbstractActor[]{sv, df});
        Trigger tr = new Trigger();
        tr.add(0, (AbstractActor)seq);
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{rng, ssv, tr});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("dumpfile.txt")));
    }

    public static Test suite() {
        return new TestSuite(SetStorageValueTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SetStorageValueTest.runTest(SetStorageValueTest.suite());
    }
}

