/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.sink.Null;
import adams.flow.source.StringConstants;
import adams.flow.transformer.StringSanitizer;
import junit.framework.Test;
import junit.framework.TestSuite;

public class StringSanitizerTest
extends AbstractFlowTest {
    public StringSanitizerTest(String name) {
        super(name);
    }

    @Override
    public AbstractActor getActor() {
        StringConstants con = new StringConstants();
        con.setStrings(new BaseString[]{new BaseString("ABCDEF"), new BaseString("ABDEF"), new BaseString("BCDEF"), new BaseString("bcDEF ")});
        StringSanitizer actor = new StringSanitizer();
        actor.setAcceptableChars("BC");
        Null nul = new Null();
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{con, actor, nul});
        return flow;
    }

    protected void performTest(String[] strIn, String[] strOut, String acceptable, String replacement, boolean invert) {
        StringSanitizer actor = new StringSanitizer();
        actor.setAcceptableChars(acceptable);
        actor.setReplacementChar(replacement);
        actor.setInvertMatching(invert);
        StringSanitizerTest.assertNull((String)"problem with setUp()", (Object)actor.setUp());
        actor.input(new Token((Object)strIn));
        StringSanitizerTest.assertNull((String)"problem with execute()", (Object)actor.execute());
        Token out = actor.output();
        StringSanitizerTest.assertNotNull((String)"problem with output()", (Object)out);
        String[] strOutActor = (String[])out.getPayload();
        StringSanitizerTest.assertEquals((String)"array length differs", (int)strOut.length, (int)strOutActor.length);
        for (int i = 0; i < strOut.length; ++i) {
            StringSanitizerTest.assertEquals((String)"values differ", (String)strOut[i], (String)strOutActor[i]);
        }
        actor.wrapUp();
        actor.cleanUp();
    }

    public void testActorReplaceDefault() {
        String[] strIn = new String[]{"ABCDEFBC", "ABDEF", "BCDEFBC", "bcDEFbc"};
        String[] strOut = new String[]{"AB--EFB-", "AB-EF", "B--EFB-", "---EF--"};
        String acceptable = "ABEFGHIJKLMNOPQRSTUVWXYZ";
        String replacement = "-";
        this.performTest(strIn, strOut, acceptable, replacement, false);
    }

    public void testActorReplaceInverted() {
        String[] strIn = new String[]{"ABCDEFBC", "ABDEF", "BCDEFBC", "bcDEFbc"};
        String[] strOut = new String[]{"--CD---C", "--D--", "-CD---C", "bcD--bc"};
        String acceptable = "ABEFGHIJKLMNOPQRSTUVWXYZ";
        String replacement = "-";
        this.performTest(strIn, strOut, acceptable, replacement, true);
    }

    public void testActorRemoveDefault() {
        String[] strIn = new String[]{"ABCDEFBC", "ABDEF", "BCDEFBC", "bcDEFbc"};
        String[] strOut = new String[]{"ABEFB", "ABEF", "BEFB", "EF"};
        String acceptable = "ABEFGHIJKLMNOPQRSTUVWXYZ";
        String replacement = "";
        this.performTest(strIn, strOut, acceptable, replacement, false);
    }

    public void testActorRemovalInverted() {
        String[] strIn = new String[]{"ABCDEFBC", "ABDEF", "BCDEFBC", "bcDEFbc"};
        String[] strOut = new String[]{"CDC", "D", "CDC", "bcDbc"};
        String acceptable = "ABEFGHIJKLMNOPQRSTUVWXYZ";
        String replacement = "";
        this.performTest(strIn, strOut, acceptable, replacement, true);
    }

    public static Test suite() {
        return new TestSuite(StringSanitizerTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        StringSanitizerTest.runTest(StringSanitizerTest.suite());
    }
}

