/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.conversion.StreamConversion;
import adams.data.statistics.StatUtils;
import java.util.Vector;

public class MovingAverage
extends AbstractConversion
implements StreamConversion {
    private static final long serialVersionUID = -4092302172529978800L;
    protected int m_WindowSize;
    protected Vector<Number> m_Queue;

    @Override
    public String globalInfo() {
        return "Computes the average on a window of numbers that have passed through and outputs the average.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("window-size", "windowSize", 10, 1, null);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Queue = new Vector();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Queue.clear();
    }

    public void setWindowSize(int value) {
        if (value > 0) {
            this.m_WindowSize = value;
            this.reset();
        } else {
            this.getSystemErr().println("Minimum window size is 1, provided: " + value);
        }
    }

    public int getWindowSize() {
        return this.m_WindowSize;
    }

    public String windowSizeTipText() {
        return "The number of data points to use for computing the average.";
    }

    @Override
    public Class accepts() {
        return Number.class;
    }

    @Override
    public Class generates() {
        return Double.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        Double result = null;
        this.m_Queue.add((Number)this.m_Input);
        while (this.m_Queue.size() > this.m_WindowSize) {
            this.m_Queue.remove(0);
        }
        if (this.m_Queue.size() == this.m_WindowSize) {
            result = StatUtils.mean(this.m_Queue.toArray(new Number[this.m_Queue.size()]));
        }
        return result;
    }
}

