/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.annotation.MixedCopyright;
import adams.gui.core.BaseSizeSequence;
import adams.gui.core.JTableHelper;
import adams.gui.core.MouseUtils;
import adams.gui.event.RemoveItemsEvent;
import adams.gui.event.RemoveItemsListener;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SizeSequence;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BaseTable
extends JTable {
    private static final long serialVersionUID = -2360462659067336490L;
    protected JTableHelper m_TableHelper;
    protected boolean m_UseDynamicRowHeight = false;
    protected SizeSequence m_RowModel;
    protected HashSet<RemoveItemsListener> m_RemoveItemsListeners;

    public BaseTable() {
        this.initGUI();
    }

    public BaseTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.initGUI();
    }

    public BaseTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.initGUI();
    }

    public BaseTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.initGUI();
    }

    public BaseTable(TableModel dm) {
        super(dm);
        this.initGUI();
    }

    public BaseTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.initGUI();
    }

    public BaseTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.initGUI();
    }

    protected JTableHelper getTableHelper() {
        if (this.m_TableHelper == null) {
            this.m_TableHelper = new JTableHelper(this);
        }
        return this.m_TableHelper;
    }

    protected void initGUI() {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick(e) && e.isControlDown() && !e.isAltDown() && !e.isShiftDown()) {
                    final int col = BaseTable.this.columnAtPoint(e.getPoint());
                    if (col != -1 && BaseTable.this.isVisible()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BaseTable.this.getTableHelper().setOptimalColumnWidth(col);
                            }
                        });
                    }
                } else if (MouseUtils.isDoubleClick(e) && e.isControlDown() && !e.isAltDown() && e.isShiftDown()) {
                    if (BaseTable.this.isVisible()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BaseTable.this.getTableHelper().setOptimalColumnWidth();
                            }
                        });
                    }
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.m_RemoveItemsListeners = new HashSet();
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseTable.this.m_RemoveItemsListeners.size() > 0 && e.getKeyCode() == 127 && e.getModifiers() == 0) {
                    e.consume();
                    BaseTable.this.notifyRemoveItemsListeners(BaseTable.this.getSelectedRows());
                }
            }
        });
    }

    public void setOptimalColumnWidth() {
        if (this.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseTable.this.getTableHelper().setOptimalColumnWidth();
                }
            });
        }
    }

    public void setOptimalColumnWidth(final int column) {
        if (this.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BaseTable.this.getTableHelper().setOptimalColumnWidth(column);
                }
            });
        }
    }

    public void setUseDynamicRowHeight(boolean value) {
        this.m_UseDynamicRowHeight = value;
    }

    public boolean getUseDynamicRowHeight() {
        return this.m_UseDynamicRowHeight;
    }

    @MixedCopyright(copyright="2004 Addision-Wesley, The Java Developers Almanac 1.4", url="http://www.exampledepot.com/egs/javax.swing.table/RowHeight.html")
    protected int determineRowHeight(int row) {
        int result;
        if (!this.m_UseDynamicRowHeight) {
            result = super.getRowHeight(row);
        } else {
            result = super.getRowHeight();
            int margin = this.getRowMargin();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                TableCellRenderer renderer = this.getCellRenderer(row, i);
                Component comp = this.prepareRenderer(renderer, row, i);
                int currHeight = comp.getPreferredSize().height + 2 * margin;
                result = Math.max(result, currHeight);
            }
        }
        return result;
    }

    protected synchronized SizeSequence getRowModel() {
        if (this.m_RowModel == null) {
            if (!this.m_UseDynamicRowHeight) {
                this.m_RowModel = new BaseSizeSequence(this.getRowCount(), this.getRowHeight());
            } else {
                int[] sizes = new int[this.getRowCount()];
                for (int i = 0; i < sizes.length; ++i) {
                    sizes[i] = this.determineRowHeight(i);
                }
                this.m_RowModel = new BaseSizeSequence(sizes);
            }
        }
        return this.m_RowModel;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        this.m_RowModel = null;
        super.setRowHeight(rowHeight);
    }

    @Override
    @MixedCopyright(copyright="2004 Addision-Wesley, The Java Developers Almanac 1.4", url="http://www.exampledepot.com/egs/javax.swing.table/RowHeight.html")
    public synchronized int getRowHeight(int row) {
        int result = this.getRowModel().getSize(row);
        if (result == -1) {
            result = this.determineRowHeight(row);
        }
        return result;
    }

    @Override
    public int rowAtPoint(Point point) {
        int result;
        if (!this.m_UseDynamicRowHeight) {
            result = super.rowAtPoint(point);
        } else {
            result = this.getRowModel().getIndex(point.y);
            if (result < 0) {
                result = -1;
            } else if (result >= this.getRowCount()) {
                result = -1;
            } else {
                return result;
            }
        }
        return result;
    }

    public void scrollRowToVisible(int row) {
        this.scrollRectToVisible(this.getCellRect(row, 0, true));
    }

    public void scrollColumnToVisible(int col) {
        this.scrollRectToVisible(this.getCellRect(0, col, true));
    }

    @Override
    public void setRowSorter(RowSorter<? extends TableModel> sorter) {
        this.m_RowModel = null;
        super.setRowSorter(sorter);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.m_RowModel = null;
        super.tableChanged(e);
    }

    public void addRemoveItemsListener(RemoveItemsListener l) {
        this.m_RemoveItemsListeners.add(l);
    }

    public void removeRemoveItemsListener(RemoveItemsListener l) {
        this.m_RemoveItemsListeners.remove(l);
    }

    protected void notifyRemoveItemsListeners(int[] indices) {
        RemoveItemsEvent event = new RemoveItemsEvent(this, indices);
        for (RemoveItemsListener l : this.m_RemoveItemsListeners) {
            l.removeItems(event);
        }
    }

    public void copyToClipboard() {
        Action copy = this.getActionMap().get("copy");
        ActionEvent event = new ActionEvent(this, 1001, "");
        copy.actionPerformed(event);
    }
}

