/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.gui.goe.AbstractIntegralNumberEditor;
import javax.swing.SpinnerNumberModel;

public class IntegerEditor
extends AbstractIntegralNumberEditor {
    public IntegerEditor() {
        this.m_CurrentValue = new Integer(0);
    }

    @Override
    public void setValue(Object value) {
        this.m_CurrentValue = new Integer(((Number)value).intValue());
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this.m_CurrentValue;
    }

    @Override
    protected Object parse(String text) throws IllegalArgumentException {
        Integer result;
        try {
            if (text.length() == 0) {
                text = "0";
            }
            result = new Integer(text);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    @Override
    protected void updateBounds(SpinnerNumberModel model) {
        if (this.m_LowerBound == null) {
            model.setMinimum(new Integer(Integer.MIN_VALUE));
        } else {
            model.setMinimum(Integer.valueOf(this.m_LowerBound.intValue()));
        }
        if (this.m_UpperBound == null) {
            model.setMaximum(new Integer(Integer.MAX_VALUE));
        } else {
            model.setMaximum(Integer.valueOf(this.m_UpperBound.intValue()));
        }
    }
}

