/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * AbstractReportHandler.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.tools.previewbrowser;

import java.io.File;
import java.util.Vector;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.Report;
import adams.gui.visualization.report.ReportFactory;

/**
 * Ancestor for handlers that display reports.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 * @see Report
 */
public abstract class AbstractReportHandler
  extends AbstractContentHandler {

  /** for serialization. */
  private static final long serialVersionUID = -3800895640927273805L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return "Displays the following report types: " + Utils.arrayToString(getExtensions());
  }

  /**
   * Returns the reader to use.
   *
   * @param file	the file to read from
   * @return		the reader
   */
  protected abstract AbstractReportReader getReader(File file);

  /**
   * Creates the actual view.
   *
   * @param file	the file to create the view for
   * @return		the view
   */
  protected JPanel createPreview(File file) {
    final ReportFactory.Panel	result;
    AbstractReportReader	reader;
    Vector			reports;
    Runnable			run;

    reader  = getReader(file);
    reader.setInput(new PlaceholderFile(file));
    reports = reader.read();
    result  = ReportFactory.getPanelForReports(reports);
    if (reports.size() > 0) {
      run = new Runnable() {
        public void run() {
          result.getReportContainerList().getTable().getSelectionModel().setSelectionInterval(0, 0);
        }
      };
      SwingUtilities.invokeLater(run);
    }
    reader.destroy();

    return result;
  }

}
