/* The following code was generated by JFlex 1.4.2 on 2/2/12 5:23 PM */

/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Scanner.java
 * Copyright (C) 2009-2012 University of Waikato, Hamilton, New Zealand
 */

package adams.parser.actorsuggestion;

import java_cup.runtime.SymbolFactory;
import java.io.*;
import java.util.*;

/**
 * A scanner for parsing actor suggestion rules.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */

public class Scanner implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int STRING = 2;
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1, 1
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\27\1\36\1\0\1\27\1\32\22\0\1\27\1\0\1\30"+
    "\1\0\1\23\3\0\1\25\1\26\4\0\1\24\22\0\1\1\1\6"+
    "\1\17\1\3\1\7\1\10\1\23\1\22\1\13\1\23\1\21\1\15"+
    "\1\20\1\2\1\4\1\12\1\23\1\5\1\14\1\11\1\16\5\23"+
    "\1\0\1\31\2\0\1\23\1\0\15\23\1\34\3\23\1\35\1\23"+
    "\1\33\6\23\uff85\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\1\1\12\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\2\2\1\0\1\2\1\12\5\2\1\13"+
    "\1\14\3\2\1\15\1\16\1\17\1\20\1\21\1\2"+
    "\1\22\17\2\1\23\1\24\5\2\1\25\1\26\1\2"+
    "\1\27\6\2\1\30\1\2\1\31\1\2\1\32\1\33"+
    "\2\2\1\34\6\2\1\35\1\36";

  private static int [] zzUnpackAction() {
    int [] result = new int[91];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\37\0\76\0\135\0\174\0\233\0\272\0\331"+
    "\0\370\0\u0117\0\u0136\0\u0155\0\u0174\0\76\0\76\0\76"+
    "\0\76\0\u0193\0\76\0\u01b2\0\u01d1\0\u01f0\0\u020f\0\u022e"+
    "\0\233\0\u024d\0\u026c\0\u028b\0\u02aa\0\u02c9\0\233\0\u02e8"+
    "\0\u0307\0\u0326\0\u0345\0\76\0\76\0\76\0\76\0\233"+
    "\0\u0364\0\233\0\u0383\0\u03a2\0\u03c1\0\u03e0\0\u03ff\0\u041e"+
    "\0\u043d\0\u045c\0\u047b\0\u049a\0\u04b9\0\u04d8\0\u04f7\0\u0516"+
    "\0\u0535\0\233\0\233\0\u0554\0\u0573\0\u0592\0\u05b1\0\u05d0"+
    "\0\233\0\233\0\u05ef\0\233\0\u060e\0\u062d\0\u064c\0\u066b"+
    "\0\u068a\0\u06a9\0\233\0\u06c8\0\233\0\u06e7\0\233\0\233"+
    "\0\u0706\0\u0725\0\233\0\u0744\0\u0763\0\u0782\0\u07a1\0\u07c0"+
    "\0\u07df\0\233\0\233";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[91];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\3\1\4\1\5\1\6\1\7\1\6\1\10\1\6"+
    "\1\11\1\12\1\13\1\14\1\15\7\6\1\3\1\16"+
    "\1\17\1\20\1\21\1\3\1\20\3\6\1\20\30\22"+
    "\1\23\1\24\1\3\3\22\41\0\1\6\1\25\5\6"+
    "\1\26\13\6\1\27\6\0\3\6\2\0\3\6\1\30"+
    "\17\6\1\27\6\0\3\6\2\0\23\6\1\27\6\0"+
    "\3\6\2\0\4\6\1\31\16\6\1\27\6\0\3\6"+
    "\2\0\6\6\1\32\14\6\1\27\6\0\3\6\2\0"+
    "\1\33\22\6\1\27\6\0\3\6\2\0\4\6\1\34"+
    "\14\6\1\35\1\6\1\27\6\0\3\6\2\0\1\36"+
    "\22\6\1\27\6\0\3\6\2\0\7\6\1\37\3\6"+
    "\1\40\7\6\1\27\6\0\3\6\2\0\3\6\1\41"+
    "\4\6\1\42\1\6\1\43\10\6\1\27\6\0\3\6"+
    "\1\0\30\22\3\0\3\22\31\0\1\44\2\0\1\45"+
    "\1\46\1\47\2\0\2\6\1\50\20\6\1\27\6\0"+
    "\3\6\2\0\10\6\1\51\12\6\1\27\6\0\3\6"+
    "\2\0\23\6\7\0\3\6\2\0\10\6\1\52\12\6"+
    "\1\27\6\0\3\6\2\0\7\6\1\53\13\6\1\27"+
    "\6\0\3\6\2\0\14\6\1\54\6\6\1\27\6\0"+
    "\3\6\2\0\1\55\14\6\1\56\5\6\1\27\6\0"+
    "\3\6\2\0\6\6\1\57\14\6\1\27\6\0\3\6"+
    "\2\0\4\6\1\60\16\6\1\27\6\0\3\6\2\0"+
    "\7\6\1\61\4\6\1\62\6\6\1\27\6\0\3\6"+
    "\2\0\15\6\1\63\5\6\1\27\6\0\3\6\2\0"+
    "\1\64\22\6\1\27\6\0\3\6\2\0\1\6\1\65"+
    "\21\6\1\27\6\0\3\6\2\0\6\6\1\66\14\6"+
    "\1\27\6\0\3\6\2\0\3\6\1\67\17\6\1\27"+
    "\6\0\3\6\2\0\13\6\1\70\7\6\1\27\6\0"+
    "\3\6\2\0\1\6\1\71\21\6\1\27\6\0\3\6"+
    "\2\0\6\6\1\72\14\6\1\27\6\0\3\6\2\0"+
    "\1\6\1\73\21\6\1\27\6\0\3\6\2\0\6\6"+
    "\1\74\14\6\1\27\6\0\3\6\2\0\12\6\1\75"+
    "\10\6\1\27\6\0\3\6\2\0\1\76\22\6\1\27"+
    "\6\0\3\6\2\0\4\6\1\77\16\6\1\27\6\0"+
    "\3\6\2\0\1\6\1\100\21\6\1\27\6\0\3\6"+
    "\2\0\20\6\1\101\2\6\1\27\6\0\3\6\2\0"+
    "\4\6\1\102\16\6\1\27\6\0\3\6\2\0\4\6"+
    "\1\103\16\6\1\27\6\0\3\6\2\0\6\6\1\104"+
    "\14\6\1\27\6\0\3\6\2\0\13\6\1\105\7\6"+
    "\1\27\6\0\3\6\2\0\1\6\1\106\21\6\1\27"+
    "\6\0\3\6\2\0\4\6\1\107\16\6\1\27\6\0"+
    "\3\6\2\0\13\6\1\110\7\6\1\27\6\0\3\6"+
    "\2\0\16\6\1\111\4\6\1\27\6\0\3\6\2\0"+
    "\2\6\1\112\20\6\1\27\6\0\3\6\2\0\6\6"+
    "\1\113\14\6\1\27\6\0\3\6\2\0\7\6\1\114"+
    "\13\6\1\27\6\0\3\6\2\0\10\6\1\115\12\6"+
    "\1\27\6\0\3\6\2\0\13\6\1\116\7\6\1\27"+
    "\6\0\3\6\2\0\10\6\1\117\12\6\1\27\6\0"+
    "\3\6\2\0\6\6\1\120\14\6\1\27\6\0\3\6"+
    "\2\0\1\121\22\6\1\27\6\0\3\6\2\0\3\6"+
    "\1\122\17\6\1\27\6\0\3\6\2\0\10\6\1\123"+
    "\12\6\1\27\6\0\3\6\2\0\14\6\1\124\6\6"+
    "\1\27\6\0\3\6\2\0\4\6\1\125\16\6\1\27"+
    "\6\0\3\6\2\0\3\6\1\126\17\6\1\27\6\0"+
    "\3\6\2\0\17\6\1\127\3\6\1\27\6\0\3\6"+
    "\2\0\1\6\1\130\21\6\1\27\6\0\3\6\2\0"+
    "\6\6\1\131\14\6\1\27\6\0\3\6\2\0\6\6"+
    "\1\132\14\6\1\27\6\0\3\6\2\0\4\6\1\133"+
    "\16\6\1\27\6\0\3\6\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[2046];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\1\11\12\1\4\11\1\1\1\11\3\1\1\0"+
    "\14\1\4\11\64\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[91];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */
  // Author: FracPete (fracpete at waikato dot ac dot nz)
  // Version: $Revision: 4584 $
  protected SymbolFactory sf;

  public Scanner(InputStream r, SymbolFactory sf){
    this(r);
    this.sf = sf;
  }
  StringBuilder string = new StringBuilder();


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Scanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Scanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 106) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 26: 
          { return sf.newSymbol("First",       sym.ISLAST);
          }
        case 31: break;
        case 30: 
          { return sf.newSymbol("Transformer", sym.TRANSFORMER);
          }
        case 32: break;
        case 15: 
          { string.append('\n');
          }
        case 33: break;
        case 10: 
          { return sf.newSymbol("Or",          sym.OR);
          }
        case 34: break;
        case 27: 
          { return sf.newSymbol("Source",      sym.SOURCE);
          }
        case 35: break;
        case 1: 
          { System.err.println("Illegal character: "+yytext());
          }
        case 36: break;
        case 2: 
          { return sf.newSymbol("Classname", sym.CLASSNAME, new String(yytext()));
          }
        case 37: break;
        case 4: 
          { return sf.newSymbol("Right Bracket", sym.RPAREN);
          }
        case 38: break;
        case 25: 
          { return sf.newSymbol("Parent" ,     sym.PARENT);
          }
        case 39: break;
        case 23: 
          { return sf.newSymbol("False",       sym.FALSE);
          }
        case 40: break;
        case 28: 
          { return sf.newSymbol("First",       sym.ISFIRST);
          }
        case 41: break;
        case 9: 
          { string.append('\\');
          }
        case 42: break;
        case 11: 
          { return sf.newSymbol("If",          sym.IF);
          }
        case 43: break;
        case 29: 
          { return sf.newSymbol("Standalone",  sym.STANDALONE);
          }
        case 44: break;
        case 6: 
          { string.setLength(0); yybegin(STRING);
          }
        case 45: break;
        case 20: 
          { return sf.newSymbol("Then",        sym.THEN);
          }
        case 46: break;
        case 3: 
          { return sf.newSymbol("Left Bracket",  sym.LPAREN);
          }
        case 47: break;
        case 22: 
          { return sf.newSymbol("After",       sym.AFTER);
          }
        case 48: break;
        case 21: 
          { return sf.newSymbol("Sink",        sym.SINK);
          }
        case 49: break;
        case 24: 
          { return sf.newSymbol("Before",      sym.BEFORE);
          }
        case 50: break;
        case 16: 
          { string.append('\r');
          }
        case 51: break;
        case 19: 
          { return sf.newSymbol("True",        sym.TRUE);
          }
        case 52: break;
        case 18: 
          { return sf.newSymbol("Not",         sym.NOT);
          }
        case 53: break;
        case 7: 
          { string.append(yytext());
          }
        case 54: break;
        case 13: 
          { string.append('\"');
          }
        case 55: break;
        case 8: 
          { yybegin(YYINITIAL);
                  return sf.newSymbol("Classname", sym.CLASSNAME, string.toString());
          }
        case 56: break;
        case 17: 
          { return sf.newSymbol("And",         sym.AND);
          }
        case 57: break;
        case 12: 
          { return sf.newSymbol("Is",          sym.IS);
          }
        case 58: break;
        case 5: 
          { /* ignore white space. */
          }
        case 59: break;
        case 14: 
          { string.append('\t');
          }
        case 60: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {     return sf.newSymbol("EOF",sym.EOF);
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
