/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.FlowFile;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.ExternalSource;
import adams.test.TmpFile;
import adams.test.TmpFlowFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class RandomNumberGeneratorTest
extends AbstractFlowTest {
    public RandomNumberGeneratorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("external_source.flow");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("external_source.flow");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        ExternalSource es = new ExternalSource();
        es.setActorFile((FlowFile)new TmpFlowFile("external_source.flow"));
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{es, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("dumpfile.txt")));
    }

    public static Test suite() {
        return new TestSuite(RandomNumberGeneratorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        RandomNumberGeneratorTest.runTest(RandomNumberGeneratorTest.suite());
    }
}

