/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.AbstractFilenameGenerator;
import adams.core.io.FixedFilenameGenerator;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.output.AbstractReportWriter;
import adams.data.io.output.DefaultSimpleCSVReportWriter;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.source.SingleFileSupplier;
import adams.flow.standalone.DatabaseConnection;
import adams.flow.transformer.ReportFileReader;
import adams.flow.transformer.ReportFileWriter;
import adams.test.TmpDirectory;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ReportFileWriterTest
extends AbstractFlowTest {
    public ReportFileWriterTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("simple.report");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("out.csv");
        this.m_TestHelper.deleteFileFromTmp("simple.report");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        DatabaseConnection dbcon = new DatabaseConnection();
        dbcon.setURL(this.getDatabaseURL());
        dbcon.setUser(this.getDatabaseUser());
        dbcon.setPassword(this.getDatabasePassword());
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("simple.report"));
        DefaultSimpleReportReader reader = new DefaultSimpleReportReader();
        ReportFileReader fr = new ReportFileReader();
        fr.setReader((AbstractReportReader)reader);
        DefaultSimpleCSVReportWriter writer = new DefaultSimpleCSVReportWriter();
        FixedFilenameGenerator ffg = new FixedFilenameGenerator();
        ffg.setName("out.csv");
        ffg.setDirectory((PlaceholderDirectory)new TmpDirectory());
        ReportFileWriter fw = new ReportFileWriter();
        fw.setWriter((AbstractReportWriter)writer);
        fw.setFilenameGenerator((AbstractFilenameGenerator)ffg);
        fw.setOutputDir(new PlaceholderDirectory(this.m_TestHelper.getTmpDirectory()));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{dbcon, sfs, fr, fw});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("out.csv")});
    }

    public static Test suite() {
        return new TestSuite(ReportFileWriterTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ReportFileWriterTest.runTest(ReportFileWriterTest.suite());
    }
}

