/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.selection;

import adams.core.Utils;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.CustomSearchTableModel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.SearchPanel;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.event.DoubleClickEvent;
import adams.gui.event.DoubleClickListener;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.selection.AbstractSelectionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractTableBasedSelectionPanel<T>
extends AbstractSelectionPanel {
    private static final long serialVersionUID = -2196072150751857296L;
    protected AbstractTableBasedSelectionPanel<T> m_Self;
    protected SortableAndSearchableTable m_TableData;
    protected AbstractSelectionTableModel<T> m_TableDataModel;
    protected JPanel m_PanelAll;
    protected SearchPanel m_SearchPanel;
    protected JPanel m_PanelAdditional;
    protected JPanel m_PanelCounts;
    protected JLabel m_LabelCounts;
    protected T[] m_Current;
    protected HashSet<DoubleClickListener> m_DoubleClickListeners;
    protected SelectionPopupMenuSupplier m_PopupMenuSupplier;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Self = this;
        this.m_Current = (Object[])Array.newInstance(this.getItemClass(), 0);
        this.m_DoubleClickListeners = new HashSet();
        this.m_PopupMenuSupplier = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelAll = new JPanel(new BorderLayout());
        this.add((Component)this.m_PanelAll, "Center");
        this.m_PanelCounts = new JPanel(new FlowLayout(0));
        this.m_PanelCounts.setVisible(false);
        this.m_LabelCounts = new JLabel(" ");
        this.m_PanelCounts.add(this.m_LabelCounts);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_PanelAll.add((Component)panel, "Center");
        this.m_TableDataModel = this.newTableModel();
        this.m_TableData = new SortableAndSearchableTable(this.m_TableDataModel);
        this.m_TableDataModel.addTableModelListener(this.m_TableData);
        this.m_TableData.setAutoResizeMode(0);
        this.m_TableData.setSelectionMode(0);
        this.m_TableData.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AbstractTableBasedSelectionPanel.this.updateCounts();
            }
        });
        this.m_TableData.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AbstractTableBasedSelectionPanel.this.m_TableData.getSelectedRow() != -1) {
                    if (MouseUtils.isDoubleClick(e)) {
                        e.consume();
                        AbstractTableBasedSelectionPanel.this.notifyDoubleClickListeners(new DoubleClickEvent(AbstractTableBasedSelectionPanel.this.m_Self));
                    } else if (MouseUtils.isRightClick(e)) {
                        e.consume();
                        int row = AbstractTableBasedSelectionPanel.this.m_TableData.rowAtPoint(new Point(e.getX(), e.getY()));
                        JPopupMenu menu = AbstractTableBasedSelectionPanel.this.m_PopupMenuSupplier.getSelectionPopupMenu(AbstractTableBasedSelectionPanel.this.m_TableData, row);
                        if (menu != null) {
                            menu.show(AbstractTableBasedSelectionPanel.this.m_TableData, e.getX(), e.getY());
                        }
                    }
                }
                if (!e.isConsumed()) {
                    super.mouseClicked(e);
                }
            }
        });
        panel.add((Component)new BaseScrollPane(this.m_TableData), "Center");
        this.m_SearchPanel = this.newSearchPanel();
        if (this.m_SearchPanel.getLayoutType() == SearchPanel.LayoutType.VERTICAL) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel.add((Component)panel2, "East");
            JPanel panel3 = new JPanel(new BorderLayout());
            panel2.add((Component)panel3, "North");
            panel3.add((Component)this.m_SearchPanel, "West");
            panel3 = new JPanel(new BorderLayout());
            panel2.add((Component)panel3, "Center");
            this.m_PanelAdditional = new JPanel(new GridLayout(0, 1));
            panel3.add((Component)this.m_PanelAdditional, "North");
        } else {
            JPanel panel2 = new JPanel(new FlowLayout(0));
            panel.add((Component)panel2, "North");
            panel2.add(this.m_SearchPanel);
            this.m_PanelAdditional = new JPanel(new GridLayout(1, 0));
            panel2.add(this.m_PanelAdditional);
        }
    }

    protected SearchPanel newSearchPanel() {
        SearchPanel result = new SearchPanel(SearchPanel.LayoutType.VERTICAL, true);
        result.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                AbstractTableBasedSelectionPanel.this.search();
            }
        });
        return result;
    }

    protected abstract AbstractSelectionTableModel<T> newTableModel();

    protected abstract Class getItemClass();

    public void setMultipleSelection(boolean value) {
        if (value) {
            this.m_TableData.setSelectionMode(2);
        } else {
            this.m_TableData.setSelectionMode(0);
        }
    }

    public boolean isMultipleSelection() {
        return this.m_TableData.getSelectionModel().getSelectionMode() == 2;
    }

    public int getSelectedRowCount() {
        return this.m_TableData.getSelectedRowCount();
    }

    protected void search() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AbstractTableBasedSelectionPanel.this.m_SearchPanel.setEnabled(false);
                AbstractTableBasedSelectionPanel.this.m_TableData.search(AbstractTableBasedSelectionPanel.this.m_SearchPanel.getSearchText(), AbstractTableBasedSelectionPanel.this.m_SearchPanel.isRegularExpression());
                AbstractTableBasedSelectionPanel.this.m_SearchPanel.setEnabled(true);
                AbstractTableBasedSelectionPanel.this.m_SearchPanel.grabFocus();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.m_TableData.getSelectionModel().addListSelectionListener(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.m_TableData.getSelectionModel().removeListSelectionListener(l);
    }

    public void addDoubleClickListener(DoubleClickListener l) {
        this.m_DoubleClickListeners.add(l);
    }

    public void removeDoubleClickListener(DoubleClickListener l) {
        this.m_DoubleClickListeners.remove(l);
    }

    protected void notifyDoubleClickListeners(DoubleClickEvent e) {
        Iterator<DoubleClickListener> iter = this.m_DoubleClickListeners.iterator();
        while (iter.hasNext()) {
            iter.next().doubleClickOccurred(e);
        }
    }

    @Override
    public void cleanUp() {
        this.m_DoubleClickListeners.clear();
    }

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.m_SearchPanel.setEnabled(value);
        this.m_TableData.setEnabled(value);
    }

    @Override
    public void grabFocus() {
        this.m_SearchPanel.grabFocus();
    }

    public int getItemCount() {
        return this.m_TableData.getRowCount();
    }

    public int getSelectedItemCount() {
        return this.m_TableData.getSelectedRowCount();
    }

    protected T[] getCurrentItems() {
        this.m_Current = (Object[])Array.newInstance(this.getItemClass(), this.m_TableData.getSelectedRowCount());
        int[] rows = this.m_TableData.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            this.m_Current[i] = this.m_TableDataModel.getItemAt(this.m_TableData.getActualRow(rows[i]));
        }
        return (Object[])this.m_Current.clone();
    }

    public T getItem() {
        if (this.getItems().length == 0) {
            return null;
        }
        return this.getItems()[0];
    }

    public T[] getItems() {
        return this.getCurrentItems();
    }

    public void setItem(T value) {
        Object[] items;
        if (value != null) {
            items = (Object[])Array.newInstance(this.getItemClass(), 1);
            Array.set(items, 0, value);
        } else {
            items = (Object[])Array.newInstance(this.getItemClass(), 0);
        }
        this.setItems(items);
    }

    protected void processMissing(Vector<T> missing) {
        System.err.println("Missing items: " + Utils.arrayToString(missing.toArray()));
    }

    protected boolean isValidItem(T item) {
        return item != null;
    }

    protected Vector<T> select(T[] value) {
        Vector<T> result = new Vector<T>();
        Vector<T> missing = new Vector<T>();
        this.m_TableData.getSelectionModel().clearSelection();
        if (value != null) {
            int row = this.m_TableData.getRowCount();
            for (int i = 0; i < value.length; ++i) {
                if (!this.isValidItem(value[i])) continue;
                int index = this.m_TableDataModel.indexOf(value[i]);
                if (index == -1) {
                    missing.add(value[i]);
                    continue;
                }
                result.add(this.m_TableDataModel.getItemAt(index));
                this.m_TableData.getSelectionModel().addSelectionInterval(this.m_TableData.getDisplayRow(index), this.m_TableData.getDisplayRow(index));
                if (this.m_TableData.getDisplayRow(index) >= row) continue;
                row = this.m_TableData.getDisplayRow(index);
            }
        }
        if (missing.size() > 0) {
            this.processMissing(missing);
        }
        return result;
    }

    public void setItems(T[] value) {
        this.m_SearchPanel.setSearchText("");
        this.m_SearchPanel.search();
        Vector<T> items = this.select(value);
        this.m_Current = (Object[])Array.newInstance(this.getItemClass(), items.size());
        for (int i = 0; i < items.size(); ++i) {
            this.m_Current[i] = items.get(i);
        }
    }

    public void scrollIntoView() {
        int row = this.m_TableData.getSelectedRow();
        if (row != -1 && row < this.m_TableData.getRowCount()) {
            this.m_TableData.scrollRowToVisible(row);
        }
    }

    @Override
    protected void beforeShow() {
        super.beforeShow();
        this.m_SearchPanel.setEnabled(this.m_TableDataModel.getRowCount() > 0);
        this.updateCounts();
    }

    public void setPopupMenuSupplier(SelectionPopupMenuSupplier value) {
        this.m_PopupMenuSupplier = value;
    }

    public SelectionPopupMenuSupplier getPopupMenuSupplier() {
        return this.m_PopupMenuSupplier;
    }

    public void setDefaultPopupMenuSupplier() {
        this.setPopupMenuSupplier(new SelectionPopupMenuSupplier(){

            @Override
            public JPopupMenu getSelectionPopupMenu(SortableAndSearchableTable table, int row) {
                JPopupMenu result = new JPopupMenu();
                for (int i = 0; i < AbstractTableBasedSelectionPanel.this.m_TableDataModel.getColumnCount(); ++i) {
                    JMenuItem menuitem = new JMenuItem("Copy '" + AbstractTableBasedSelectionPanel.this.m_TableDataModel.getColumnName(i) + "'");
                    final Object obj = AbstractTableBasedSelectionPanel.this.m_TableData.getValueAt(row, i);
                    menuitem.setEnabled(obj != null);
                    menuitem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (obj != null) {
                                GUIHelper.copyToClipboard(obj.toString());
                            }
                        }
                    });
                    result.add(menuitem);
                }
                return result;
            }
        });
    }

    public void setCountsVisible(boolean value) {
        this.m_PanelCounts.setVisible(value);
        if (value) {
            this.m_PanelAll.add((Component)this.m_PanelCounts, "South");
            this.updateCounts();
        } else {
            this.m_PanelAll.remove(this.m_PanelCounts);
        }
    }

    public boolean isCountsVisible() {
        return this.m_PanelCounts.isVisible();
    }

    protected void updateCounts() {
        this.m_LabelCounts.setText("Total: " + this.m_TableData.getRowCount() + ", Selected: " + this.m_TableData.getSelectedRowCount());
    }

    public static interface SelectionPopupMenuSupplier {
        public JPopupMenu getSelectionPopupMenu(SortableAndSearchableTable var1, int var2);
    }

    public static abstract class AbstractSelectionTableModel<T>
    extends AbstractBaseTableModel
    implements CustomSearchTableModel {
        private static final long serialVersionUID = -6034857465096265433L;

        public abstract T getItemAt(int var1);

        public abstract int indexOf(T var1);
    }
}

