/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * EventsNode.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.goe.eventstree;

import adams.flow.standalone.Events;
import adams.gui.goe.actorpathtree.ActorPathNode;

/**
 * Specialized tree node.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class EventsNode
  extends ActorPathNode {

  /** for serialization. */
  private static final long serialVersionUID = 7329048118794889190L;

  /**
   * Initializes the class node with the specified label (package or class
   * name).
   *
   * @param label	the label for this node
   */
  public EventsNode(String label) {
    super(label);
  }

  /**
   * Returns whether this node represents an event.
   *
   * @return		true if an event
   */
  public boolean isEvent() {
    return ((m_Classname != null) && !m_Classname.equals(Events.class.getName()));
  }
}