/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * GlobalActorsNode.java
 * Copyright (C) 2011-2012 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.goe.globalactorstree;

import adams.flow.standalone.GlobalActors;
import adams.gui.goe.actorpathtree.ActorPathNode;

/**
 * Specialized tree node.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class GlobalActorsNode
  extends ActorPathNode {

  /** for serialization. */
  private static final long serialVersionUID = 9062259637831548370L;

  /**
   * Initializes the class node with the specified label (package or class
   * name).
   *
   * @param label	the label for this node
   */
  public GlobalActorsNode(String label) {
    super(label);
  }

  /**
   * Returns whether this node represents a global actor.
   *
   * @return		true if a global actor
   */
  public boolean isGlobalActor() {
    return ((m_Classname != null) && !m_Classname.equals(GlobalActors.class.getName()));
  }
}