/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * GlobalActorsTree.java
 * Copyright (C) 2011-2012 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.goe.globalactorstree;

import java.util.Enumeration;

import javax.swing.tree.TreePath;

import adams.gui.core.BaseTreeNode;
import adams.gui.goe.actorpathtree.ActorPathTree;

/**
 * Displays classes in a tree structure.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4584 $
 */
public class GlobalActorsTree
  extends ActorPathTree<GlobalActorsNode> {

  /** for serialization. */
  private static final long serialVersionUID = 1489354474021395304L;

  /**
   * Initializes the tree with no classes.
   */
  public GlobalActorsTree() {
    super();
  }

  /**
   * Returns a new instance of a node.
   *
   * @param label	the label to use
   * @return		the new node
   * @see		#newNode(String)
   */
  protected GlobalActorsNode newNodeInstance(String label) {
    return new GlobalActorsNode(label);
  }

  /**
   * Selects the global actor identified by the name.
   *
   * @param name	the name of the global actor
   */
  public GlobalActorsNode findGlobalActor(String name) {
    GlobalActorsNode	result;
    BaseTreeNode	node;
    Enumeration		enm;
    GlobalActorsNode	child;

    result = null;

    if ((name != null) && (name.length() > 0)) {
      node = (BaseTreeNode) getTreeModel().getRoot();
      if (node != null) {
	enm = node.breadthFirstEnumeration();
	while (enm.hasMoreElements()) {
	  node = (BaseTreeNode) enm.nextElement();
	  if (node instanceof GlobalActorsNode) {
	    child = (GlobalActorsNode) node;
	    if (child.isGlobalActor() && child.getLabel().equals(name)) {
	      result = child;
	      break;
	    }
	  }
	}
      }
    }

    return result;
  }

  /**
   * Selects the global actor identified by the name.
   *
   * @param name	the name of the global actor
   */
  public void selectGlobalActor(String name) {
    GlobalActorsNode	node;
    TreePath		path;

    node = findGlobalActor(name);
    if (node != null) {
      path = new TreePath(node.getPath());
      setSelectionPath(path);
    }
  }
}
