/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.env.Environment;
import adams.flow.core.ActorPath;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ActorPathTest
extends AdamsTestCase {
    public ActorPathTest(String name) {
        super(name);
    }

    public static void testSingleElement() {
        ActorPath path = new ActorPath("hello");
        ActorPathTest.assertEquals((String)"Path length differs", (int)1, (int)path.getPathCount());
        ActorPathTest.assertEquals((String)"Path element differs", (String)"hello", (String)path.getPathComponent(0));
    }

    public static void testMultipleElements() {
        ActorPath path = new ActorPath("hello.world.out.there");
        ActorPathTest.assertEquals((String)"Path length differs", (int)4, (int)path.getPathCount());
        ActorPathTest.assertEquals((String)"Path element 1 differs", (String)"hello", (String)path.getPathComponent(0));
        ActorPathTest.assertEquals((String)"Path element 2 differs", (String)"world", (String)path.getPathComponent(1));
        ActorPathTest.assertEquals((String)"Path element 3 differs", (String)"out", (String)path.getPathComponent(2));
        ActorPathTest.assertEquals((String)"Path element 4 differs", (String)"there", (String)path.getPathComponent(3));
    }

    public static void testBlankInElement() {
        ActorPath path = new ActorPath("hello world.out.there");
        ActorPathTest.assertEquals((String)"Path length differs", (int)3, (int)path.getPathCount());
        ActorPathTest.assertEquals((String)"Path element 1 differs", (String)"hello world", (String)path.getPathComponent(0));
        ActorPathTest.assertEquals((String)"Path element 2 differs", (String)"out", (String)path.getPathComponent(1));
        ActorPathTest.assertEquals((String)"Path element 3 differs", (String)"there", (String)path.getPathComponent(2));
    }

    public static void testDotInElement() {
        ActorPath path = new ActorPath("hello\\.world.out.there");
        ActorPathTest.assertEquals((String)"Path length differs", (int)3, (int)path.getPathCount());
        ActorPathTest.assertEquals((String)"Path element 1 differs", (String)"hello.world", (String)path.getPathComponent(0));
        ActorPathTest.assertEquals((String)"Path element 2 differs", (String)"out", (String)path.getPathComponent(1));
        ActorPathTest.assertEquals((String)"Path element 3 differs", (String)"there", (String)path.getPathComponent(2));
    }

    public static void testConsoleString() {
        ActorPath path = new ActorPath("[Flow.ContainerValuePicker/700475288-DEBUG]");
        ActorPathTest.assertEquals((String)"Path length differs", (int)2, (int)path.getPathCount());
        ActorPathTest.assertEquals((String)"Path element 1 differs", (String)"Flow", (String)path.getPathComponent(0));
        ActorPathTest.assertEquals((String)"Path element 2 differs", (String)"ContainerValuePicker", (String)path.getPathComponent(1));
    }

    public static void testToString() {
        String s = "hello\\.world.out.there";
        ActorPath path = new ActorPath(s);
        ActorPathTest.assertEquals((String)"Path differs", (String)s, (String)path.toString());
        s = "hello.world.out.there";
        path = new ActorPath(s);
        ActorPathTest.assertEquals((String)"Path differs", (String)s, (String)path.toString());
        s = "hello";
        path = new ActorPath(s);
        ActorPathTest.assertEquals((String)"Path differs", (String)s, (String)path.toString());
        s = "hel lo";
        path = new ActorPath(s);
        ActorPathTest.assertEquals((String)"Path differs", (String)s, (String)path.toString());
        s = "hello world.out.there";
        path = new ActorPath(s);
        ActorPathTest.assertEquals((String)"Path differs", (String)s, (String)path.toString());
    }

    public static void testDescendant() {
        ActorPath path1 = new ActorPath("a.b");
        ActorPath path2 = new ActorPath("a.b.c");
        ActorPathTest.assertEquals((String)"isDescendant failed", (boolean)true, (boolean)path1.isDescendant(path2));
        path2 = new ActorPath("a");
        ActorPathTest.assertEquals((String)"isDescendant failed", (boolean)false, (boolean)path1.isDescendant(path2));
        path2 = new ActorPath("a.b");
        ActorPathTest.assertEquals((String)"isDescendant failed", (boolean)true, (boolean)path1.isDescendant(path2));
    }

    public static void testCommonAncestor() {
        ActorPath path1 = new ActorPath("a.b");
        ActorPath path2 = new ActorPath("a.b.c");
        ActorPathTest.assertEquals((String)"getCommonAncestor failed", (String)"a.b", (String)path1.getCommonAncestor(path2).toString());
        path2 = new ActorPath("a");
        ActorPathTest.assertEquals((String)"getCommonAncestor failed", (String)"a", (String)path1.getCommonAncestor(path2).toString());
        path2 = new ActorPath("a.b");
        ActorPathTest.assertEquals((String)"getCommonAncestor failed", (String)"a.b", (String)path1.getCommonAncestor(path2).toString());
        path2 = new ActorPath("b");
        ActorPathTest.assertEquals((String)"getCommonAncestor failed", (String)"", (String)path1.getCommonAncestor(path2).toString());
        path2 = new ActorPath("b.c.d");
        ActorPathTest.assertEquals((String)"getCommonAncestor failed", (String)"", (String)path1.getCommonAncestor(path2).toString());
    }

    public static void testCompareTo() {
        ActorPath path1 = new ActorPath("a.b");
        ActorPath path2 = new ActorPath("a.b.c");
        ActorPathTest.assertEquals((String)("compareTo failed (" + path1 + ", " + path2 + ")"), (boolean)true, (path1.compareTo(path2) < 0 ? 1 : 0) != 0);
        path2 = new ActorPath("a.b");
        ActorPathTest.assertEquals((String)("compareTo failed (" + path1 + ", " + path2 + ")"), (boolean)true, (path1.compareTo(path2) == 0 ? 1 : 0) != 0);
        path2 = new ActorPath("a.c");
        ActorPathTest.assertEquals((String)("compareTo failed (" + path1 + ", " + path2 + ")"), (boolean)true, (path1.compareTo(path2) < 0 ? 1 : 0) != 0);
        path2 = new ActorPath("b.c");
        ActorPathTest.assertEquals((String)("compareTo failed (" + path1 + ", " + path2 + ")"), (boolean)true, (path1.compareTo(path2) < 0 ? 1 : 0) != 0);
        path2 = new ActorPath("a.a.c");
        ActorPathTest.assertEquals((String)("compareTo failed (" + path1 + ", " + path2 + ")"), (boolean)true, (path1.compareTo(path2) > 0 ? 1 : 0) != 0);
    }

    public static void testEquals() {
        ActorPath path1 = new ActorPath("a.b");
        ActorPath path2 = new ActorPath("a.b.c");
        ActorPathTest.assertEquals((String)("equals failed (" + path1 + ", " + path2 + ")"), (boolean)false, (boolean)path1.equals((Object)path2));
        path2 = new ActorPath("a.b");
        ActorPathTest.assertEquals((String)("equals failed (" + path1 + ", " + path2 + ")"), (boolean)true, (boolean)path1.equals((Object)path2));
        ActorPathTest.assertEquals((String)"equals failed (integer)", (boolean)false, (boolean)path1.equals((Object)new Integer(3)));
    }

    public static void testFirstPathComponent() {
        ActorPath path = new ActorPath("a.b");
        ActorPathTest.assertEquals((String)("getFirstPathComponent failed (" + path + ")"), (String)"a", (String)path.getFirstPathComponent());
        path = new ActorPath("a");
        ActorPathTest.assertEquals((String)("getFirstPathComponent failed (" + path + ")"), (String)"a", (String)path.getFirstPathComponent());
        path = new ActorPath("");
        ActorPathTest.assertEquals((String)("getFirstPathComponent failed (" + path + ")"), null, (String)path.getFirstPathComponent());
    }

    public static void testLastPathComponent() {
        ActorPath path = new ActorPath("a.b");
        ActorPathTest.assertEquals((String)("getLastPathComponent failed (" + path + ")"), (String)"b", (String)path.getLastPathComponent());
        path = new ActorPath("a");
        ActorPathTest.assertEquals((String)("getLastPathComponent failed (" + path + ")"), (String)"a", (String)path.getLastPathComponent());
        path = new ActorPath("");
        ActorPathTest.assertEquals((String)("getLastPathComponent failed (" + path + ")"), null, (String)path.getLastPathComponent());
    }

    public static Test suite() {
        return new TestSuite(ActorPathTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ActorPathTest.runTest(ActorPathTest.suite());
    }
}

