/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.template;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.option.NestedProducer;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.template.AbstractActorTemplate;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractActorTemplateTestCase
extends AbstractDatabaseTestCase {
    public AbstractActorTemplateTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/flow/template/data");
    }

    protected abstract AbstractActorTemplate[] getRegressionSetups();

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    protected String createOutputFilename(AbstractActorTemplate cond, int no) {
        return cond.getClass().getName() + "-out" + no + ".txt";
    }

    protected boolean save(AbstractActor actor, String filename) {
        String content;
        if (actor == null) {
            content = "<null>";
        } else {
            NestedProducer producer = new NestedProducer();
            producer.setOutputProlog(false);
            producer.produce((OptionHandler)actor);
            content = producer.toString();
            producer.cleanUp();
        }
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)content, (boolean)false);
    }

    public void testRegression() {
        int i;
        AbstractActorTemplate[] setups = this.getRegressionSetups();
        String[] output = new String[setups.length];
        AbstractActorTemplateTestCase.assertEquals((String)"Number of files and setups differ!", (int)output.length, (int)setups.length);
        for (i = 0; i < output.length; ++i) {
            AbstractActor processed = setups[i].generate();
            output[i] = this.createOutputFilename(setups[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractActorTemplateTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, this.getRegressionIgnoredLineIndices());
        AbstractActorTemplateTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

