/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderDirectory;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.source.StringConstants;
import adams.flow.transformer.CopyFile;
import adams.test.TmpDirectory;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class CopyFileTest
extends AbstractFlowTest {
    public CopyFileTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("${TMP}/bolts.csv")});
        CopyFile cf = new CopyFile();
        cf.setRegExp(new BaseRegExp("BLAH"));
        cf.setTargetDirectory((PlaceholderDirectory)new TmpDirectory());
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sc, cf});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("bolts.csv")));
    }

    public static Test suite() {
        return new TestSuite(CopyFileTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        CopyFileTest.runTest(CopyFileTest.suite());
    }
}

