/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.parser.AbstractExpressionEvaluator;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractExpressionEvaluatorTestCase<D, E extends AbstractExpressionEvaluator>
extends AdamsTestCase {
    public AbstractExpressionEvaluatorTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/parser/data");
    }

    protected Object[] process(String[] expressions, E scheme) {
        Object[] result = new Object[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            scheme.setExpression(expressions[i]);
            try {
                result[i] = scheme.evaluate();
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to evaluate expression '" + expressions[i] + "' using '" + OptionUtils.getCommandLine(scheme) + "':");
                e.printStackTrace();
                result[i] = null;
            }
        }
        return result;
    }

    protected abstract String[][] getRegressionExpressions();

    protected abstract E[] getRegressionSetups();

    protected boolean save(String[] expressions, Object[] data, String filename) {
        String[] content = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            content[i] = expressions[i] + ": " + data[i];
        }
        return FileUtils.saveToFile((String[])content, (File)((Object)new TmpFile(filename)));
    }

    protected String createOutputFilename(int no) {
        return "out-" + no;
    }

    public void testRegression() {
        int i;
        String[][] expr = this.getRegressionExpressions();
        String[] output = new String[expr.length];
        AbstractExpressionEvaluator[] setups = this.getRegressionSetups();
        AbstractExpressionEvaluatorTestCase.assertEquals((String)"Number of expression arrays and setups differ!", (int)expr.length, (int)setups.length);
        for (i = 0; i < expr.length; ++i) {
            Object[] processed = this.process(expr[i], setups[i]);
            AbstractExpressionEvaluatorTestCase.assertNotNull((String)"Failed to process data?", (Object)processed);
            output[i] = this.createOutputFilename(i);
            boolean ok = this.save(expr[i], processed, output[i]);
            AbstractExpressionEvaluatorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractExpressionEvaluatorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

