/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class WrapperHashSet<E>
extends AbstractCollection<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 7724908287353061207L;
    protected HashSet<Wrapper> m_HashSet;

    public WrapperHashSet() {
        this.m_HashSet = new HashSet();
    }

    public WrapperHashSet(Collection<? extends E> c) {
        this.m_HashSet = new HashSet();
        this.addAll(c);
    }

    public WrapperHashSet(int initialCapacity, float loadFactor) {
        this.m_HashSet = new HashSet(initialCapacity, loadFactor);
    }

    public WrapperHashSet(int initialCapacity) {
        this.m_HashSet = new HashSet(initialCapacity);
    }

    @Override
    public void clear() {
        this.m_HashSet.clear();
    }

    public Object clone() {
        WrapperHashSet<E> result = new WrapperHashSet<E>();
        result.m_HashSet = (HashSet)this.m_HashSet.clone();
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        Vector<Object> result = new Vector<Object>();
        for (Wrapper w : this.m_HashSet) {
            result.add(w.getPayload());
        }
        return result.iterator();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_HashSet.contains(new Wrapper(o));
    }

    @Override
    public boolean add(E e) {
        return this.m_HashSet.add(new Wrapper(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.m_HashSet.remove(new Wrapper(o));
    }

    @Override
    public boolean isEmpty() {
        return this.m_HashSet.isEmpty();
    }

    @Override
    public int size() {
        return this.m_HashSet.size();
    }

    @Override
    public String toString() {
        return this.m_HashSet.toString();
    }

    public static class Wrapper
    implements Serializable {
        private static final long serialVersionUID = -4446213875293513654L;
        protected Object m_Payload;

        public Wrapper(Object payload) {
            this.m_Payload = payload;
        }

        public Object getPayload() {
            return this.m_Payload;
        }

        public int hashCode() {
            return this.m_Payload.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return ((Wrapper)o).hashCode() == this.hashCode();
        }

        public String toString() {
            return this.m_Payload.toString();
        }
    }
}

