/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.AbstractOptionalSampleArrayStatistic;
import adams.data.statistics.StatUtils;

public class ArrayStandardDeviation<T extends Number>
extends AbstractOptionalSampleArrayStatistic<T> {
    private static final long serialVersionUID = 2678844088824196816L;

    @Override
    public String globalInfo() {
        return "Calculates the standard deviation for a numeric array.";
    }

    @Override
    public int getMin() {
        return 1;
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        AbstractArrayStatistic.StatisticContainer<Double> result = new AbstractArrayStatistic.StatisticContainer<Double>(1, this.size());
        String prefix = "stdev";
        prefix = this.getIsSample() ? prefix + "-sample" : prefix + "-pop.";
        for (int i = 0; i < this.size(); ++i) {
            if (this.size() > 1) {
                result.setHeader(i, prefix + "-" + (i + 1));
            } else {
                result.setHeader(i, prefix);
            }
            result.setCell(0, i, StatUtils.stddev((Number[])this.get(i), this.getIsSample()));
        }
        return result;
    }
}

