/*
 * Decompiled with CFR 0.152.
 */
package adams.db.indices;

public class IndexColumn {
    protected String m_asc_or_desc;
    protected String m_columnName;
    protected int m_Length;

    public IndexColumn(String cname) {
        this(cname, true);
    }

    public IndexColumn(String cname, boolean ascending) {
        this(cname, ascending, -1);
    }

    public IndexColumn(String cname, boolean ascending, int length) {
        this(cname, ascending ? "A" : "D", length);
    }

    public IndexColumn(String cname, String asc_or_desc) {
        this(cname, asc_or_desc, -1);
    }

    public IndexColumn(String cname, String asc_or_desc, int length) {
        this.m_columnName = cname;
        this.m_asc_or_desc = asc_or_desc;
        this.m_Length = length;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public String getAscOrDesc() {
        return this.m_asc_or_desc;
    }

    public int getLength() {
        return this.m_Length;
    }

    public boolean equals(IndexColumn ic) {
        return this.toString().equals(ic.toString());
    }

    public String toString() {
        String result = this.m_columnName;
        if (this.m_Length != -1) {
            result = result + "(" + this.m_Length + ")";
        }
        result = this.m_asc_or_desc.equals("D") ? result + " DESC" : result + " ASC";
        return result;
    }
}

