/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.AbstractHistory;
import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.gui.event.HistorySelectionEvent;
import adams.gui.event.HistorySelectionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ObjectHistory
extends AbstractHistory<Object> {
    private static final long serialVersionUID = -1255734638729633595L;
    protected Vector m_History;

    @Override
    protected Object copy(Object obj) {
        return Utils.deepCopy(obj);
    }

    protected String generateMenuItemCaption(Object obj) {
        StringBuffer result = new StringBuffer();
        String cmd = OptionUtils.getCommandLine(obj);
        if (cmd.length() > 200) {
            cmd = cmd.substring(0, 200) + "...";
        }
        String[] lines = Utils.breakUp(cmd, 50);
        result.append("<html>");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                result.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            result.append(lines[i].trim());
        }
        result.append("</html>");
        return result.toString();
    }

    public void customizePopupMenu(JPopupMenu menu, Object current, HistorySelectionListener listener) {
        JMenu submenu = new JMenu("History");
        menu.add(submenu);
        JMenuItem item = new JMenuItem("Clear history");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectHistory.this.m_History.clear();
            }
        });
        submenu.add(item);
        final HistorySelectionListener fListener = listener;
        for (int i = 0; i < this.m_History.size(); ++i) {
            if (i == 0) {
                submenu.addSeparator();
            }
            final Object history = this.m_History.get(i);
            item = new JMenuItem(this.generateMenuItemCaption(history));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    fListener.historySelected(new HistorySelectionEvent(fListener, history));
                }
            });
            submenu.add(item);
        }
    }
}

