/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.report;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.container.VisibilityContainerManager;
import adams.gui.visualization.core.AbstractPaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.plot.Axis;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Date;

public class ReportDateFieldRangePaintlet
extends AbstractPaintlet
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 5013286925457654660L;
    protected Field m_Start;
    protected Field m_End;
    protected String m_Format;
    protected Color m_Color;
    protected transient DateFormat m_DateFormat;

    @Override
    public String globalInfo() {
        return "Paintlet for painting a background region based on the date stored in a report.\nFor more details on the date format, see:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("start", "start", new Field(null, DataType.STRING));
        this.m_OptionManager.add("end", "end", new Field(null, DataType.STRING));
        this.m_OptionManager.add("format", "format", "yyyy-MM-dd HH:mm:ss");
        this.m_OptionManager.add("color", "color", GUIHelper.getColor(this.getClass(), "color", Color.LIGHT_GRAY));
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        return new DateFormat().getTechnicalInformation();
    }

    public void setStart(Field value) {
        if (value != this.m_Start || value != null && !value.equals(this.m_Start)) {
            this.m_Start = value;
            this.memberChanged();
        }
    }

    public Field getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The date field in the report to use as start of the region.";
    }

    public void setEnd(Field value) {
        if (value != this.m_End || value != null && !value.equals(this.m_End)) {
            this.m_End = value;
            this.memberChanged();
        }
    }

    public Field getEnd() {
        return this.m_End;
    }

    public String endTipText() {
        return "The date field in the report to use as end of the region.";
    }

    public void setFormat(String value) {
        if (value != this.m_Format || value != null && !value.equals(this.m_Format)) {
            this.m_Format = value;
            this.memberChanged();
        }
    }

    public String getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The date format to use for parsing the value stored in the report.";
    }

    public void setColor(Color value) {
        if (value != this.m_Color || value != null && !value.equals(this.m_Color)) {
            this.m_Color = value;
            this.memberChanged();
        }
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for the background region.";
    }

    @Override
    public void setPanel(PaintablePanel value) {
        if (!(value instanceof DataContainerPanel)) {
            throw new IllegalArgumentException("Panel is not derived from " + DataContainerPanel.class.getName() + "!");
        }
        super.setPanel(value);
    }

    protected synchronized DateFormat getDateFormat() {
        if (this.m_DateFormat == null) {
            this.m_DateFormat = new DateFormat(this.m_Format);
        }
        return this.m_DateFormat;
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.BACKGROUND;
    }

    @Override
    public void performPaint(Graphics g) {
        DataContainerPanel panel = (DataContainerPanel)this.getPanel();
        Object manager = panel.getContainerManager();
        DateFormat dformat = this.getDateFormat();
        Date startDateGlobal = null;
        Date endDateGlobal = null;
        for (int i = 0; i < ((ContainerManager)manager).count(); ++i) {
            Object cont = ((ContainerManager)manager).get(i);
            if (manager instanceof VisibilityContainerManager && !((VisibilityContainer)cont).isVisible()) continue;
            Object report = ((Container)cont).getPayload() instanceof ReportHandler ? ((ReportHandler)((Object)((Container)cont).getPayload())).getReport() : (((Container)cont).getPayload() instanceof Report ? (Report)((Container)cont).getPayload() : null);
            if (report != null && ((Report)report).hasValue(this.m_Start)) {
                Date endDate;
                Date startDate;
                String dateStr;
                try {
                    dateStr = ((Report)report).getStringValue(this.m_Start);
                    startDate = dformat.parse(dateStr);
                }
                catch (Exception e) {
                    startDate = null;
                    this.getSystemErr().println("Failed to parse field '" + this.m_Start + "' using format '" + this.m_Format + "':");
                    this.getSystemErr().printStackTrace(e);
                }
                try {
                    dateStr = ((Report)report).getStringValue(this.m_End);
                    endDate = dformat.parse(dateStr);
                }
                catch (Exception e) {
                    endDate = null;
                    this.getSystemErr().println("Failed to parse field '" + this.m_End + "' using format '" + this.m_Format + "':");
                    this.getSystemErr().printStackTrace(e);
                }
                if (startDate != null && endDate != null) {
                    if (startDateGlobal == null) {
                        startDateGlobal = startDate;
                    } else if (DateUtils.isBefore(startDateGlobal, startDate)) {
                        startDateGlobal = startDate;
                    }
                    if (endDateGlobal == null) {
                        endDateGlobal = endDate;
                    } else if (DateUtils.isAfter(endDateGlobal, endDate)) {
                        endDateGlobal = endDate;
                    }
                }
            }
            if (startDateGlobal == null || endDateGlobal == null) continue;
            AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
            g.setColor(this.getColor());
            g.fillRect(axisX.valueToPos(startDateGlobal.getTime()), 0, axisX.valueToPos(endDateGlobal.getTime()) - axisX.valueToPos(startDateGlobal.getTime()), this.getPanel().getHeight());
        }
    }
}

