/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * InetAddressHelper.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Vector;

/**
 * Helper class for internet related stuff.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4604 $
 */
public class InternetHelper {

  /** IP (from network intf) for faster access. */
  protected static String m_IPNetworkInterface;

  /** host name (from network intf) for faster access. */
  protected static String m_HostnameNetworkInterface;

  /** IP for faster access. */
  protected static String m_IP;

  /** host name for faster access. */
  protected static String m_Hostname;
  
  /**
   * Returns the IP address determined from the network interfaces (using 
   * the IP address of the one with a proper host name).
   * 
   * @return 		the IP address
   */
  public static synchronized String getIPFromNetworkInterface() {
    String				result;
    Vector<String>			list;
    Enumeration<NetworkInterface>	enmI;
    NetworkInterface			intf;
    Enumeration<InetAddress>		enmA;
    InetAddress				addr;
    boolean				found;
    
    result = null;
    
    if (m_IPNetworkInterface == null) {
      list   = new Vector<String>();
      found  = false;
      try {
	enmI = NetworkInterface.getNetworkInterfaces();
	while (enmI.hasMoreElements()) {
	  intf = enmI.nextElement();
	  enmA = intf.getInetAddresses();
	  while (enmA.hasMoreElements()) {
	    addr = enmA.nextElement();
	    list.add(addr.getHostAddress());
	    if (addr.getHostName().indexOf(':') == -1) {
	      result = addr.getHostAddress();
	      found  = true;
	      break;
	    }
	  }
	  if (found)
	    break;
	}
      }
      catch (Exception e) {
	// ignored
      }

      if (result == null) {
	if (list.size() > 0)
	  result = list.get(0);
	else
	  result = "<unknown>";
      }
      
      m_IPNetworkInterface = result;
    }
    else {
      result = m_IPNetworkInterface;
    }
    
    return result;
  }

  /**
   * Returns the host name determined from the network interfaces.
   * 
   * @return 		the host name, null if none found
   */
  public static synchronized String getHostnameFromNetworkInterface() {
    String				result;
    Vector<String>			list;
    Enumeration<NetworkInterface>	enmI;
    NetworkInterface			intf;
    Enumeration<InetAddress>		enmA;
    InetAddress				addr;
    boolean				found;

    result = null;

    if (m_HostnameNetworkInterface == null) {
      list   = new Vector<String>();
      found  = false;
      try {
	enmI = NetworkInterface.getNetworkInterfaces();
	while (enmI.hasMoreElements()) {
	  intf = enmI.nextElement();
	  enmA = intf.getInetAddresses();
	  while (enmA.hasMoreElements()) {
	    addr = enmA.nextElement();
	    list.add(addr.getHostName());
	    if (addr.getHostName().indexOf(':') == -1) {
	      result = addr.getHostName();
	      found  = true;
	      break;
	    }
	  }
	  if (found)
	    break;
	}
      }
      catch (Exception e) {
	// ignored
      }

      if (result == null) {
	if (list.size() > 0)
	  result = list.get(0);
	else
	  result = "<unknown>";
      }
      
      m_HostnameNetworkInterface = result;
    }
    else {
      result = m_HostnameNetworkInterface;
    }
    
    return result;
  }
  
  /**
   * Returns the IP address of the local host as string.
   *
   * @return		the IP address, null if not available
   */
  public static synchronized String getLocalHostIP() {
    String	result;

    if (m_IP == null) {
      try {
	result = InetAddress.getLocalHost().getHostAddress();
      }
      catch (Exception e) {
	result = getIPFromNetworkInterface();
      }
      
      m_IP = result;
    }
    else {
      result = m_IP;
    }

    return result;
  }

  /**
   * Returns the machine name of the local host as string.
   *
   * @return		the machine name, null if not available
   */
  public static synchronized String getLocalHostName() {
    String	result;

    if (m_Hostname == null) {
      try {
	result = InetAddress.getLocalHost().getHostName();
      }
      catch (Exception e) {
	result = getHostnameFromNetworkInterface();
      }
      
      m_Hostname = result;
    }
    else {
      result = m_Hostname;
    }

    return result;
  }
}
